// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Describes the status of the test operation along with error information, if applicable. </summary>
    public partial class StreamAnalyticsResourceTestStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsResourceTestStatus"/>. </summary>
        internal StreamAnalyticsResourceTestStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsResourceTestStatus"/>. </summary>
        /// <param name="status"> The status of the test operation. </param>
        /// <param name="code"> Error code associated with the error that occurred. </param>
        /// <param name="message"> Describes the error in detail. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamAnalyticsResourceTestStatus(string status, string code, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            Code = code;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The status of the test operation. </summary>
        public string Status { get; }
        /// <summary> Error code associated with the error that occurred. </summary>
        public string Code { get; }
        /// <summary> Describes the error in detail. </summary>
        public string Message { get; }
    }
}
