// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> The result of the query compilation request. </summary>
    public partial class StreamAnalyticsQueryCompilationResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsQueryCompilationResult"/>. </summary>
        internal StreamAnalyticsQueryCompilationResult()
        {
            Errors = new ChangeTrackingList<StreamAnalyticsQueryCompilationError>();
            Warnings = new ChangeTrackingList<string>();
            Inputs = new ChangeTrackingList<string>();
            Outputs = new ChangeTrackingList<string>();
            Functions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsQueryCompilationResult"/>. </summary>
        /// <param name="errors"> Error messages produced by the compiler. </param>
        /// <param name="warnings"> Warning messages produced by the compiler. </param>
        /// <param name="inputs"> All input names used by the query. </param>
        /// <param name="outputs"> All output names used by the query. </param>
        /// <param name="functions"> All function names used by the query. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamAnalyticsQueryCompilationResult(IReadOnlyList<StreamAnalyticsQueryCompilationError> errors, IReadOnlyList<string> warnings, IReadOnlyList<string> inputs, IReadOnlyList<string> outputs, IReadOnlyList<string> functions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Errors = errors;
            Warnings = warnings;
            Inputs = inputs;
            Outputs = outputs;
            Functions = functions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Error messages produced by the compiler. </summary>
        public IReadOnlyList<StreamAnalyticsQueryCompilationError> Errors { get; }
        /// <summary> Warning messages produced by the compiler. </summary>
        public IReadOnlyList<string> Warnings { get; }
        /// <summary> All input names used by the query. </summary>
        public IReadOnlyList<string> Inputs { get; }
        /// <summary> All output names used by the query. </summary>
        public IReadOnlyList<string> Outputs { get; }
        /// <summary> All function names used by the query. </summary>
        public IReadOnlyList<string> Functions { get; }
    }
}
