// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. </summary>
    public readonly partial struct StreamAnalyticsDataSerializationEncoding : IEquatable<StreamAnalyticsDataSerializationEncoding>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsDataSerializationEncoding"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamAnalyticsDataSerializationEncoding(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Utf8Value = "UTF8";

        /// <summary> UTF8. </summary>
        public static StreamAnalyticsDataSerializationEncoding Utf8 { get; } = new StreamAnalyticsDataSerializationEncoding(Utf8Value);
        /// <summary> Determines if two <see cref="StreamAnalyticsDataSerializationEncoding"/> values are the same. </summary>
        public static bool operator ==(StreamAnalyticsDataSerializationEncoding left, StreamAnalyticsDataSerializationEncoding right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamAnalyticsDataSerializationEncoding"/> values are not the same. </summary>
        public static bool operator !=(StreamAnalyticsDataSerializationEncoding left, StreamAnalyticsDataSerializationEncoding right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamAnalyticsDataSerializationEncoding"/>. </summary>
        public static implicit operator StreamAnalyticsDataSerializationEncoding(string value) => new StreamAnalyticsDataSerializationEncoding(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamAnalyticsDataSerializationEncoding other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamAnalyticsDataSerializationEncoding other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
