// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> The status of the cluster provisioning. The three terminal states are: Succeeded, Failed and Canceled. </summary>
    public readonly partial struct StreamAnalyticsClusterProvisioningState : IEquatable<StreamAnalyticsClusterProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsClusterProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamAnalyticsClusterProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string InProgressValue = "InProgress";

        /// <summary> The cluster provisioning succeeded. </summary>
        public static StreamAnalyticsClusterProvisioningState Succeeded { get; } = new StreamAnalyticsClusterProvisioningState(SucceededValue);
        /// <summary> The cluster provisioning failed. </summary>
        public static StreamAnalyticsClusterProvisioningState Failed { get; } = new StreamAnalyticsClusterProvisioningState(FailedValue);
        /// <summary> The cluster provisioning was canceled. </summary>
        public static StreamAnalyticsClusterProvisioningState Canceled { get; } = new StreamAnalyticsClusterProvisioningState(CanceledValue);
        /// <summary> The cluster provisioning was inprogress. </summary>
        public static StreamAnalyticsClusterProvisioningState InProgress { get; } = new StreamAnalyticsClusterProvisioningState(InProgressValue);
        /// <summary> Determines if two <see cref="StreamAnalyticsClusterProvisioningState"/> values are the same. </summary>
        public static bool operator ==(StreamAnalyticsClusterProvisioningState left, StreamAnalyticsClusterProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamAnalyticsClusterProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(StreamAnalyticsClusterProvisioningState left, StreamAnalyticsClusterProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamAnalyticsClusterProvisioningState"/>. </summary>
        public static implicit operator StreamAnalyticsClusterProvisioningState(string value) => new StreamAnalyticsClusterProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamAnalyticsClusterProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamAnalyticsClusterProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
