// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> The binding to an Azure Machine Learning web service. </summary>
    public partial class MachineLearningServiceFunctionBinding : StreamingJobFunctionBinding
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningServiceFunctionBinding"/>. </summary>
        public MachineLearningServiceFunctionBinding()
        {
            Inputs = new ChangeTrackingList<MachineLearningServiceInputColumn>();
            Outputs = new ChangeTrackingList<MachineLearningServiceOutputColumn>();
            FunctionBindingType = "Microsoft.MachineLearningServices";
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningServiceFunctionBinding"/>. </summary>
        /// <param name="functionBindingType"> Indicates the function binding type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="endpoint"> The Request-Response execute endpoint of the Azure Machine Learning web service. </param>
        /// <param name="apiKey"> The API key used to authenticate with Request-Response endpoint. </param>
        /// <param name="inputs"> The inputs for the Azure Machine Learning web service endpoint. </param>
        /// <param name="outputs"> A list of outputs from the Azure Machine Learning web service endpoint execution. </param>
        /// <param name="batchSize"> Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000. </param>
        /// <param name="numberOfParallelRequests"> The number of parallel requests that will be sent per partition of your job to the machine learning service. Default is 1. </param>
        /// <param name="inputRequestName"> Label for the input request object. </param>
        /// <param name="outputResponseName"> Label for the output request object. </param>
        internal MachineLearningServiceFunctionBinding(string functionBindingType, IDictionary<string, BinaryData> serializedAdditionalRawData, string endpoint, string apiKey, IList<MachineLearningServiceInputColumn> inputs, IList<MachineLearningServiceOutputColumn> outputs, int? batchSize, int? numberOfParallelRequests, string inputRequestName, string outputResponseName) : base(functionBindingType, serializedAdditionalRawData)
        {
            Endpoint = endpoint;
            ApiKey = apiKey;
            Inputs = inputs;
            Outputs = outputs;
            BatchSize = batchSize;
            NumberOfParallelRequests = numberOfParallelRequests;
            InputRequestName = inputRequestName;
            OutputResponseName = outputResponseName;
            FunctionBindingType = functionBindingType ?? "Microsoft.MachineLearningServices";
        }

        /// <summary> The Request-Response execute endpoint of the Azure Machine Learning web service. </summary>
        public string Endpoint { get; set; }
        /// <summary> The API key used to authenticate with Request-Response endpoint. </summary>
        public string ApiKey { get; set; }
        /// <summary> The inputs for the Azure Machine Learning web service endpoint. </summary>
        public IList<MachineLearningServiceInputColumn> Inputs { get; }
        /// <summary> A list of outputs from the Azure Machine Learning web service endpoint execution. </summary>
        public IList<MachineLearningServiceOutputColumn> Outputs { get; }
        /// <summary> Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000. </summary>
        public int? BatchSize { get; set; }
        /// <summary> The number of parallel requests that will be sent per partition of your job to the machine learning service. Default is 1. </summary>
        public int? NumberOfParallelRequests { get; set; }
        /// <summary> Label for the input request object. </summary>
        public string InputRequestName { get; set; }
        /// <summary> Label for the output request object. </summary>
        public string OutputResponseName { get; set; }
    }
}
