// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Describes a blob input data source that contains stream data. </summary>
    public partial class GatewayMessageBusStreamInputDataSource : StreamInputDataSource
    {
        /// <summary> Initializes a new instance of <see cref="GatewayMessageBusStreamInputDataSource"/>. </summary>
        public GatewayMessageBusStreamInputDataSource()
        {
            StreamInputDataSourceType = "GatewayMessageBus";
        }

        /// <summary> Initializes a new instance of <see cref="GatewayMessageBusStreamInputDataSource"/>. </summary>
        /// <param name="streamInputDataSourceType"> Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="topic"> The name of the Service Bus topic. </param>
        internal GatewayMessageBusStreamInputDataSource(string streamInputDataSourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string topic) : base(streamInputDataSourceType, serializedAdditionalRawData)
        {
            Topic = topic;
            StreamInputDataSourceType = streamInputDataSourceType ?? "GatewayMessageBus";
        }

        /// <summary> The name of the Service Bus topic. </summary>
        public string Topic { get; set; }
    }
}
