// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Describes a Gateway Message Bus output data source. </summary>
    public partial class GatewayMessageBusOutputDataSource : StreamingJobOutputDataSource
    {
        /// <summary> Initializes a new instance of <see cref="GatewayMessageBusOutputDataSource"/>. </summary>
        public GatewayMessageBusOutputDataSource()
        {
            OutputDataSourceType = "GatewayMessageBus";
        }

        /// <summary> Initializes a new instance of <see cref="GatewayMessageBusOutputDataSource"/>. </summary>
        /// <param name="outputDataSourceType"> Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="topic"> The name of the Service Bus topic. </param>
        internal GatewayMessageBusOutputDataSource(string outputDataSourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string topic) : base(outputDataSourceType, serializedAdditionalRawData)
        {
            Topic = topic;
            OutputDataSourceType = outputDataSourceType ?? "GatewayMessageBus";
        }

        /// <summary> The name of the Service Bus topic. </summary>
        public string Topic { get; set; }
    }
}
