// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Indicates the policy to apply to events that arrive out of order in the input event stream. </summary>
    public readonly partial struct EventsOutOfOrderPolicy : IEquatable<EventsOutOfOrderPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventsOutOfOrderPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventsOutOfOrderPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AdjustValue = "Adjust";
        private const string DropValue = "Drop";

        /// <summary> Adjust. </summary>
        public static EventsOutOfOrderPolicy Adjust { get; } = new EventsOutOfOrderPolicy(AdjustValue);
        /// <summary> Drop. </summary>
        public static EventsOutOfOrderPolicy Drop { get; } = new EventsOutOfOrderPolicy(DropValue);
        /// <summary> Determines if two <see cref="EventsOutOfOrderPolicy"/> values are the same. </summary>
        public static bool operator ==(EventsOutOfOrderPolicy left, EventsOutOfOrderPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventsOutOfOrderPolicy"/> values are not the same. </summary>
        public static bool operator !=(EventsOutOfOrderPolicy left, EventsOutOfOrderPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventsOutOfOrderPolicy"/>. </summary>
        public static implicit operator EventsOutOfOrderPolicy(string value) => new EventsOutOfOrderPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventsOutOfOrderPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventsOutOfOrderPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
