// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Describes an event grid input data source that contains stream data. </summary>
    public partial class EventGridStreamInputDataSource : StreamInputDataSource
    {
        /// <summary> Initializes a new instance of <see cref="EventGridStreamInputDataSource"/>. </summary>
        public EventGridStreamInputDataSource()
        {
            StorageAccounts = new ChangeTrackingList<StreamAnalyticsStorageAccount>();
            EventTypes = new ChangeTrackingList<string>();
            StreamInputDataSourceType = "Microsoft.EventGrid/EventSubscriptions";
        }

        /// <summary> Initializes a new instance of <see cref="EventGridStreamInputDataSource"/>. </summary>
        /// <param name="streamInputDataSourceType"> Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="subscriber"> Subscribers for the Event Grid. Currently only EventHub Subscriber is supported. </param>
        /// <param name="schema"> Indicates the Event Grid schema type. </param>
        /// <param name="storageAccounts"> A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="eventTypes"> List of Event Types that are supported by the Event Grid adapter. </param>
        internal EventGridStreamInputDataSource(string streamInputDataSourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, EventHubV2StreamInputDataSource subscriber, EventGridEventSchemaType? schema, IList<StreamAnalyticsStorageAccount> storageAccounts, IList<string> eventTypes) : base(streamInputDataSourceType, serializedAdditionalRawData)
        {
            Subscriber = subscriber;
            Schema = schema;
            StorageAccounts = storageAccounts;
            EventTypes = eventTypes;
            StreamInputDataSourceType = streamInputDataSourceType ?? "Microsoft.EventGrid/EventSubscriptions";
        }

        /// <summary> Subscribers for the Event Grid. Currently only EventHub Subscriber is supported. </summary>
        public EventHubV2StreamInputDataSource Subscriber { get; set; }
        /// <summary> Indicates the Event Grid schema type. </summary>
        public EventGridEventSchemaType? Schema { get; set; }
        /// <summary> A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests. </summary>
        public IList<StreamAnalyticsStorageAccount> StorageAccounts { get; }
        /// <summary> List of Event Types that are supported by the Event Grid adapter. </summary>
        public IList<string> EventTypes { get; }
    }
}
