// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Supported Event Grid schema types. </summary>
    public readonly partial struct EventGridEventSchemaType : IEquatable<EventGridEventSchemaType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventGridEventSchemaType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventGridEventSchemaType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EventGridEventSchemaValue = "EventGridEventSchema";
        private const string CloudEventSchemaValue = "CloudEventSchema";

        /// <summary> EventGridEventSchema. </summary>
        public static EventGridEventSchemaType EventGridEventSchema { get; } = new EventGridEventSchemaType(EventGridEventSchemaValue);
        /// <summary> CloudEventSchema. </summary>
        public static EventGridEventSchemaType CloudEventSchema { get; } = new EventGridEventSchemaType(CloudEventSchemaValue);
        /// <summary> Determines if two <see cref="EventGridEventSchemaType"/> values are the same. </summary>
        public static bool operator ==(EventGridEventSchemaType left, EventGridEventSchemaType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventGridEventSchemaType"/> values are not the same. </summary>
        public static bool operator !=(EventGridEventSchemaType left, EventGridEventSchemaType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventGridEventSchemaType"/>. </summary>
        public static implicit operator EventGridEventSchemaType(string value) => new EventGridEventSchemaType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventGridEventSchemaType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventGridEventSchemaType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
