// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Indicates the type of data refresh option. </summary>
    public readonly partial struct DataRefreshType : IEquatable<DataRefreshType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataRefreshType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataRefreshType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StaticValue = "Static";
        private const string RefreshPeriodicallyWithFullValue = "RefreshPeriodicallyWithFull";
        private const string RefreshPeriodicallyWithDeltaValue = "RefreshPeriodicallyWithDelta";
        private const string BlockingValue = "Blocking";
        private const string NonblockingValue = "Nonblocking";

        /// <summary> Static. </summary>
        public static DataRefreshType Static { get; } = new DataRefreshType(StaticValue);
        /// <summary> RefreshPeriodicallyWithFull. </summary>
        public static DataRefreshType RefreshPeriodicallyWithFull { get; } = new DataRefreshType(RefreshPeriodicallyWithFullValue);
        /// <summary> RefreshPeriodicallyWithDelta. </summary>
        public static DataRefreshType RefreshPeriodicallyWithDelta { get; } = new DataRefreshType(RefreshPeriodicallyWithDeltaValue);
        /// <summary> Blocking. </summary>
        public static DataRefreshType Blocking { get; } = new DataRefreshType(BlockingValue);
        /// <summary> Nonblocking. </summary>
        public static DataRefreshType Nonblocking { get; } = new DataRefreshType(NonblockingValue);
        /// <summary> Determines if two <see cref="DataRefreshType"/> values are the same. </summary>
        public static bool operator ==(DataRefreshType left, DataRefreshType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataRefreshType"/> values are not the same. </summary>
        public static bool operator !=(DataRefreshType left, DataRefreshType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataRefreshType"/>. </summary>
        public static implicit operator DataRefreshType(string value) => new DataRefreshType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataRefreshType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataRefreshType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
