// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Describes an Azure Data Lake Store output data source. </summary>
    public partial class DataLakeStoreOutputDataSource : StreamingJobOutputDataSource
    {
        /// <summary> Initializes a new instance of <see cref="DataLakeStoreOutputDataSource"/>. </summary>
        public DataLakeStoreOutputDataSource()
        {
            OutputDataSourceType = "Microsoft.DataLake/Accounts";
        }

        /// <summary> Initializes a new instance of <see cref="DataLakeStoreOutputDataSource"/>. </summary>
        /// <param name="outputDataSourceType"> Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="refreshToken"> A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="tokenUserPrincipalName"> The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token. </param>
        /// <param name="tokenUserDisplayName"> The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token. </param>
        /// <param name="accountName"> The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="tenantId"> The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="filePathPrefix"> The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="dateFormat"> The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead. </param>
        /// <param name="timeFormat"> The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead. </param>
        /// <param name="authenticationMode"> Authentication Mode. </param>
        internal DataLakeStoreOutputDataSource(string outputDataSourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string refreshToken, string tokenUserPrincipalName, string tokenUserDisplayName, string accountName, Guid? tenantId, string filePathPrefix, string dateFormat, string timeFormat, StreamAnalyticsAuthenticationMode? authenticationMode) : base(outputDataSourceType, serializedAdditionalRawData)
        {
            RefreshToken = refreshToken;
            TokenUserPrincipalName = tokenUserPrincipalName;
            TokenUserDisplayName = tokenUserDisplayName;
            AccountName = accountName;
            TenantId = tenantId;
            FilePathPrefix = filePathPrefix;
            DateFormat = dateFormat;
            TimeFormat = timeFormat;
            AuthenticationMode = authenticationMode;
            OutputDataSourceType = outputDataSourceType ?? "Microsoft.DataLake/Accounts";
        }

        /// <summary> A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests. </summary>
        public string RefreshToken { get; set; }
        /// <summary> The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token. </summary>
        public string TokenUserPrincipalName { get; set; }
        /// <summary> The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token. </summary>
        public string TokenUserDisplayName { get; set; }
        /// <summary> The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests. </summary>
        public string AccountName { get; set; }
        /// <summary> The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests. </summary>
        public Guid? TenantId { get; set; }
        /// <summary> The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests. </summary>
        public string FilePathPrefix { get; set; }
        /// <summary> The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead. </summary>
        public string DateFormat { get; set; }
        /// <summary> The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead. </summary>
        public string TimeFormat { get; set; }
        /// <summary> Authentication Mode. </summary>
        public StreamAnalyticsAuthenticationMode? AuthenticationMode { get; set; }
    }
}
