// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    public partial class CustomClrFormatSerialization : IUtf8JsonSerializable, IJsonModel<CustomClrFormatSerialization>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CustomClrFormatSerialization>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CustomClrFormatSerialization>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomClrFormatSerialization>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomClrFormatSerialization)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(SerializationDllPath))
            {
                writer.WritePropertyName("serializationDllPath"u8);
                writer.WriteStringValue(SerializationDllPath);
            }
            if (Optional.IsDefined(SerializationClassName))
            {
                writer.WritePropertyName("serializationClassName"u8);
                writer.WriteStringValue(SerializationClassName);
            }
            writer.WriteEndObject();
        }

        CustomClrFormatSerialization IJsonModel<CustomClrFormatSerialization>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomClrFormatSerialization>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomClrFormatSerialization)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCustomClrFormatSerialization(document.RootElement, options);
        }

        internal static CustomClrFormatSerialization DeserializeCustomClrFormatSerialization(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            EventSerializationType type = default;
            string serializationDllPath = default;
            string serializationClassName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    type = new EventSerializationType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("serializationDllPath"u8))
                        {
                            serializationDllPath = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("serializationClassName"u8))
                        {
                            serializationClassName = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CustomClrFormatSerialization(type, serializedAdditionalRawData, serializationDllPath, serializationClassName);
        }

        BinaryData IPersistableModel<CustomClrFormatSerialization>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomClrFormatSerialization>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CustomClrFormatSerialization)} does not support writing '{options.Format}' format.");
            }
        }

        CustomClrFormatSerialization IPersistableModel<CustomClrFormatSerialization>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomClrFormatSerialization>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCustomClrFormatSerialization(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CustomClrFormatSerialization)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CustomClrFormatSerialization>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
