// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> The binding to a CSharp function. </summary>
    public partial class CSharpFunctionBinding : StreamingJobFunctionBinding
    {
        /// <summary> Initializes a new instance of <see cref="CSharpFunctionBinding"/>. </summary>
        public CSharpFunctionBinding()
        {
            FunctionBindingType = "Microsoft.StreamAnalytics/CLRUdf";
        }

        /// <summary> Initializes a new instance of <see cref="CSharpFunctionBinding"/>. </summary>
        /// <param name="functionBindingType"> Indicates the function binding type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="dllPath"> The Csharp code containing a single function definition. </param>
        /// <param name="class"> The Csharp code containing a single function definition. </param>
        /// <param name="method"> The Csharp code containing a single function definition. </param>
        /// <param name="updateMode"> Refresh modes for Stream Analytics functions. </param>
        internal CSharpFunctionBinding(string functionBindingType, IDictionary<string, BinaryData> serializedAdditionalRawData, string dllPath, string @class, string method, StreamingJobFunctionUpdateMode? updateMode) : base(functionBindingType, serializedAdditionalRawData)
        {
            DllPath = dllPath;
            Class = @class;
            Method = method;
            UpdateMode = updateMode;
            FunctionBindingType = functionBindingType ?? "Microsoft.StreamAnalytics/CLRUdf";
        }

        /// <summary> The Csharp code containing a single function definition. </summary>
        public string DllPath { get; set; }
        /// <summary> The Csharp code containing a single function definition. </summary>
        public string Class { get; set; }
        /// <summary> The Csharp code containing a single function definition. </summary>
        public string Method { get; set; }
        /// <summary> Refresh modes for Stream Analytics functions. </summary>
        public StreamingJobFunctionUpdateMode? UpdateMode { get; set; }
    }
}
