// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Describes a blob input data source that contains reference data. </summary>
    public partial class BlobReferenceInputDataSource : ReferenceInputDataSource
    {
        /// <summary> Initializes a new instance of <see cref="BlobReferenceInputDataSource"/>. </summary>
        public BlobReferenceInputDataSource()
        {
            StorageAccounts = new ChangeTrackingList<StreamAnalyticsStorageAccount>();
            ReferenceInputDataSourceType = "Microsoft.Storage/Blob";
        }

        /// <summary> Initializes a new instance of <see cref="BlobReferenceInputDataSource"/>. </summary>
        /// <param name="referenceInputDataSourceType"> Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="storageAccounts"> A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="container"> The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="pathPattern"> The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example. </param>
        /// <param name="dateFormat"> The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead. </param>
        /// <param name="timeFormat"> The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead. </param>
        /// <param name="authenticationMode"> Authentication Mode. </param>
        /// <param name="blobName"> The name of the blob input. </param>
        /// <param name="deltaPathPattern"> The path pattern of the delta snapshot. </param>
        /// <param name="sourcePartitionCount"> The partition count of the blob input data source. Range 1 - 256. </param>
        /// <param name="fullSnapshotRefreshInterval"> The refresh interval of the blob input data source. </param>
        /// <param name="deltaSnapshotRefreshInterval"> The interval that the user generates a delta snapshot of this reference blob input data source. </param>
        internal BlobReferenceInputDataSource(string referenceInputDataSourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<StreamAnalyticsStorageAccount> storageAccounts, string container, string pathPattern, string dateFormat, string timeFormat, StreamAnalyticsAuthenticationMode? authenticationMode, string blobName, string deltaPathPattern, int? sourcePartitionCount, TimeSpan? fullSnapshotRefreshInterval, TimeSpan? deltaSnapshotRefreshInterval) : base(referenceInputDataSourceType, serializedAdditionalRawData)
        {
            StorageAccounts = storageAccounts;
            Container = container;
            PathPattern = pathPattern;
            DateFormat = dateFormat;
            TimeFormat = timeFormat;
            AuthenticationMode = authenticationMode;
            BlobName = blobName;
            DeltaPathPattern = deltaPathPattern;
            SourcePartitionCount = sourcePartitionCount;
            FullSnapshotRefreshInterval = fullSnapshotRefreshInterval;
            DeltaSnapshotRefreshInterval = deltaSnapshotRefreshInterval;
            ReferenceInputDataSourceType = referenceInputDataSourceType ?? "Microsoft.Storage/Blob";
        }

        /// <summary> A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests. </summary>
        public IList<StreamAnalyticsStorageAccount> StorageAccounts { get; }
        /// <summary> The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests. </summary>
        public string Container { get; set; }
        /// <summary> The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example. </summary>
        public string PathPattern { get; set; }
        /// <summary> The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead. </summary>
        public string DateFormat { get; set; }
        /// <summary> The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead. </summary>
        public string TimeFormat { get; set; }
        /// <summary> Authentication Mode. </summary>
        public StreamAnalyticsAuthenticationMode? AuthenticationMode { get; set; }
        /// <summary> The name of the blob input. </summary>
        public string BlobName { get; set; }
        /// <summary> The path pattern of the delta snapshot. </summary>
        public string DeltaPathPattern { get; set; }
        /// <summary> The partition count of the blob input data source. Range 1 - 256. </summary>
        public int? SourcePartitionCount { get; set; }
        /// <summary> The refresh interval of the blob input data source. </summary>
        public TimeSpan? FullSnapshotRefreshInterval { get; set; }
        /// <summary> The interval that the user generates a delta snapshot of this reference blob input data source. </summary>
        public TimeSpan? DeltaSnapshotRefreshInterval { get; set; }
    }
}
