// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Determines whether blob blocks are either committed automatically or appended. </summary>
    public readonly partial struct BlobOutputWriteMode : IEquatable<BlobOutputWriteMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BlobOutputWriteMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BlobOutputWriteMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AppendValue = "Append";
        private const string OnceValue = "Once";

        /// <summary> Append. </summary>
        public static BlobOutputWriteMode Append { get; } = new BlobOutputWriteMode(AppendValue);
        /// <summary> Once. </summary>
        public static BlobOutputWriteMode Once { get; } = new BlobOutputWriteMode(OnceValue);
        /// <summary> Determines if two <see cref="BlobOutputWriteMode"/> values are the same. </summary>
        public static bool operator ==(BlobOutputWriteMode left, BlobOutputWriteMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BlobOutputWriteMode"/> values are not the same. </summary>
        public static bool operator !=(BlobOutputWriteMode left, BlobOutputWriteMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BlobOutputWriteMode"/>. </summary>
        public static implicit operator BlobOutputWriteMode(string value) => new BlobOutputWriteMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BlobOutputWriteMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BlobOutputWriteMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
