// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.StreamAnalytics.Models;

namespace Azure.ResourceManager.StreamAnalytics
{
    internal class StreamAnalyticsResourceTestStatusOperationSource : IOperationSource<StreamAnalyticsResourceTestStatus>
    {
        StreamAnalyticsResourceTestStatus IOperationSource<StreamAnalyticsResourceTestStatus>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return StreamAnalyticsResourceTestStatus.DeserializeStreamAnalyticsResourceTestStatus(document.RootElement);
        }

        async ValueTask<StreamAnalyticsResourceTestStatus> IOperationSource<StreamAnalyticsResourceTestStatus>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return StreamAnalyticsResourceTestStatus.DeserializeStreamAnalyticsResourceTestStatus(document.RootElement);
        }
    }
}
