// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmStreamAnalyticsModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="StreamAnalytics.StreamingJobFunctionData"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="properties">
        /// The properties that are associated with a function.
        /// Please note <see cref="Models.StreamingJobFunctionProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.AggregateFunctionProperties"/> and <see cref="Models.ScalarFunctionProperties"/>.
        /// </param>
        /// <returns> A new <see cref="StreamAnalytics.StreamingJobFunctionData"/> instance for mocking. </returns>
        public static StreamingJobFunctionData StreamingJobFunctionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, StreamingJobFunctionProperties properties = null)
        {
            return new StreamingJobFunctionData(id, name, resourceType, serializedAdditionalRawData: null, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamingJobFunctionProperties"/>. </summary>
        /// <param name="functionPropertiesType"> Indicates the type of function. </param>
        /// <param name="etag"> The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency. </param>
        /// <param name="inputs"></param>
        /// <param name="outputDataType"> Describes the output of a function. </param>
        /// <param name="binding">
        /// The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
        /// Please note <see cref="StreamingJobFunctionBinding"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="EMachineLearningStudioFunctionBinding"/>, <see cref="MachineLearningServiceFunctionBinding"/>, <see cref="CSharpFunctionBinding"/> and <see cref="JavaScriptFunctionBinding"/>.
        /// </param>
        /// <returns> A new <see cref="Models.StreamingJobFunctionProperties"/> instance for mocking. </returns>
        public static StreamingJobFunctionProperties StreamingJobFunctionProperties(string functionPropertiesType = null, ETag? etag = null, IEnumerable<StreamingJobFunctionInput> inputs = null, string outputDataType = null, StreamingJobFunctionBinding binding = null)
        {
            inputs ??= new List<StreamingJobFunctionInput>();

            return new UnknownFunctionProperties(
                functionPropertiesType,
                etag,
                inputs?.ToList(),
                outputDataType != null ? new StreamingJobFunctionOutput(outputDataType, serializedAdditionalRawData: null) : null,
                binding,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsSubResource"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsSubResource"/> instance for mocking. </returns>
        public static StreamAnalyticsSubResource StreamAnalyticsSubResource(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null)
        {
            return new StreamAnalyticsSubResource(id, name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsError"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="target"> Error target. </param>
        /// <param name="details"> Error details. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsError"/> instance for mocking. </returns>
        public static StreamAnalyticsError StreamAnalyticsError(string code = null, string message = null, string target = null, IEnumerable<StreamAnalyticsErrorDetails> details = null)
        {
            details ??= new List<StreamAnalyticsErrorDetails>();

            return new StreamAnalyticsError(code, message, target, details?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsErrorDetails"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="target"> Error target. </param>
        /// <param name="message"> Error message. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsErrorDetails"/> instance for mocking. </returns>
        public static StreamAnalyticsErrorDetails StreamAnalyticsErrorDetails(string code = null, string target = null, string message = null)
        {
            return new StreamAnalyticsErrorDetails(code, target, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsResourceTestStatus"/>. </summary>
        /// <param name="status"> The status of the test operation. </param>
        /// <param name="code"> Error code associated with the error that occurred. </param>
        /// <param name="message"> Describes the error in detail. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsResourceTestStatus"/> instance for mocking. </returns>
        public static StreamAnalyticsResourceTestStatus StreamAnalyticsResourceTestStatus(string status = null, string code = null, string message = null)
        {
            return new StreamAnalyticsResourceTestStatus(status, code, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StreamAnalytics.StreamingJobInputData"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="properties">
        /// The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
        /// Please note <see cref="Models.StreamingJobInputProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ReferenceInputProperties"/> and <see cref="Models.StreamInputProperties"/>.
        /// </param>
        /// <returns> A new <see cref="StreamAnalytics.StreamingJobInputData"/> instance for mocking. </returns>
        public static StreamingJobInputData StreamingJobInputData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, StreamingJobInputProperties properties = null)
        {
            return new StreamingJobInputData(id, name, resourceType, serializedAdditionalRawData: null, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamingJobInputProperties"/>. </summary>
        /// <param name="inputPropertiesType"> Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="serialization">
        /// Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        /// Please note <see cref="StreamAnalyticsDataSerialization"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AvroFormatSerialization"/>, <see cref="CsvFormatSerialization"/>, <see cref="CustomClrFormatSerialization"/>, <see cref="JsonFormatSerialization"/> and <see cref="ParquetFormatSerialization"/>.
        /// </param>
        /// <param name="diagnosticsConditions"> Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention. </param>
        /// <param name="etag"> The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency. </param>
        /// <param name="compressionType"> Describes how input data is compressed. </param>
        /// <param name="partitionKey"> partitionKey Describes a key in the input data which is used for partitioning the input data. </param>
        /// <param name="watermarkMode"> Settings which determine whether to read watermark events. </param>
        /// <returns> A new <see cref="Models.StreamingJobInputProperties"/> instance for mocking. </returns>
        public static StreamingJobInputProperties StreamingJobInputProperties(string inputPropertiesType = null, StreamAnalyticsDataSerialization serialization = null, IEnumerable<StreamingJobDiagnosticCondition> diagnosticsConditions = null, ETag? etag = null, StreamingCompressionType? compressionType = null, string partitionKey = null, StreamingJobInputWatermarkMode? watermarkMode = null)
        {
            diagnosticsConditions ??= new List<StreamingJobDiagnosticCondition>();

            return new UnknownInputProperties(
                inputPropertiesType,
                serialization,
                diagnosticsConditions != null ? new StreamingJobDiagnostics(diagnosticsConditions?.ToList(), serializedAdditionalRawData: null) : null,
                etag,
                compressionType.HasValue ? new StreamingCompression(compressionType.Value, serializedAdditionalRawData: null) : null,
                partitionKey,
                watermarkMode != null ? new StreamingJobInputWatermarkProperties(watermarkMode, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamingJobDiagnosticCondition"/>. </summary>
        /// <param name="since"> The UTC timestamp of when the condition started. Customers should be able to find a corresponding event in the ops log around this time. </param>
        /// <param name="code"> The opaque diagnostic code. </param>
        /// <param name="message"> The human-readable message describing the condition in detail. Localized in the Accept-Language of the client request. </param>
        /// <returns> A new <see cref="Models.StreamingJobDiagnosticCondition"/> instance for mocking. </returns>
        public static StreamingJobDiagnosticCondition StreamingJobDiagnosticCondition(DateTimeOffset? since = null, string code = null, string message = null)
        {
            return new StreamingJobDiagnosticCondition(since, code, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StreamAnalytics.StreamingJobOutputData"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="datasource">
        /// Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
        /// Please note <see cref="StreamingJobOutputDataSource"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="GatewayMessageBusOutputDataSource"/>, <see cref="FunctionOutputDataSource"/>, <see cref="DataLakeStoreOutputDataSource"/>, <see cref="PostgreSQLOutputDataSource"/>, <see cref="EventHubV2OutputDataSource"/>, <see cref="EventHubOutputDataSource"/>, <see cref="ServiceBusQueueOutputDataSource"/>, <see cref="ServiceBusTopicOutputDataSource"/>, <see cref="SqlDatabaseOutputDataSource"/>, <see cref="SynapseOutputDataSource"/>, <see cref="BlobOutputDataSource"/>, <see cref="DocumentDbOutputDataSource"/>, <see cref="TableOutputDataSource"/>, <see cref="PowerBIOutputDataSource"/> and <see cref="RawOutputDatasource"/>.
        /// </param>
        /// <param name="timeFrame"> The time frame for filtering Stream Analytics job outputs. </param>
        /// <param name="sizeWindow"> The size window to constrain a Stream Analytics output to. </param>
        /// <param name="serialization">
        /// Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        /// Please note <see cref="StreamAnalyticsDataSerialization"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AvroFormatSerialization"/>, <see cref="CsvFormatSerialization"/>, <see cref="CustomClrFormatSerialization"/>, <see cref="JsonFormatSerialization"/> and <see cref="ParquetFormatSerialization"/>.
        /// </param>
        /// <param name="diagnosticsConditions"> Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention. </param>
        /// <param name="etag"> The current entity tag for the output. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency. </param>
        /// <param name="lastOutputEventTimestamps"> A list of the last output event times for each output partition. The index of the array corresponds to the partition number. </param>
        /// <param name="watermarkSettings"> Settings which determine whether to send watermarks to downstream. </param>
        /// <returns> A new <see cref="StreamAnalytics.StreamingJobOutputData"/> instance for mocking. </returns>
        public static StreamingJobOutputData StreamingJobOutputData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, StreamingJobOutputDataSource datasource = null, TimeSpan? timeFrame = null, float? sizeWindow = null, StreamAnalyticsDataSerialization serialization = null, IEnumerable<StreamingJobDiagnosticCondition> diagnosticsConditions = null, ETag? etag = null, IEnumerable<LastOutputEventTimestamp> lastOutputEventTimestamps = null, StreamingJobOutputWatermarkProperties watermarkSettings = null)
        {
            diagnosticsConditions ??= new List<StreamingJobDiagnosticCondition>();
            lastOutputEventTimestamps ??= new List<LastOutputEventTimestamp>();

            return new StreamingJobOutputData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                datasource,
                timeFrame,
                sizeWindow,
                serialization,
                diagnosticsConditions != null ? new StreamingJobDiagnostics(diagnosticsConditions?.ToList(), serializedAdditionalRawData: null) : null,
                etag,
                lastOutputEventTimestamps?.ToList(),
                watermarkSettings);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LastOutputEventTimestamp"/>. </summary>
        /// <param name="lastOutputEventOn"> The last output event time. </param>
        /// <param name="lastUpdatedOn"> The time that the last update happened. </param>
        /// <returns> A new <see cref="Models.LastOutputEventTimestamp"/> instance for mocking. </returns>
        public static LastOutputEventTimestamp LastOutputEventTimestamp(DateTimeOffset? lastOutputEventOn = null, DateTimeOffset? lastUpdatedOn = null)
        {
            return new LastOutputEventTimestamp(lastOutputEventOn, lastUpdatedOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StreamAnalytics.StreamingJobData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Describes the managed identity assigned to this job that can be used to authenticate with inputs and outputs. Current supported identity types: SystemAssigned, UserAssigned, SystemAssigned,UserAssigned. </param>
        /// <param name="skuName"> Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="jobId"> A GUID uniquely identifying the streaming job. This GUID is generated upon creation of the streaming job. </param>
        /// <param name="provisioningState"> Describes the provisioning status of the streaming job. </param>
        /// <param name="jobState"> Describes the state of the streaming job. </param>
        /// <param name="jobType"> Describes the type of the job. Valid modes are `Cloud` and 'Edge'. </param>
        /// <param name="outputStartMode"> This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time. </param>
        /// <param name="outputStartOn"> Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null to indicate that the output event stream will start whenever the streaming job is started. This property must have a value if outputStartMode is set to CustomTime. </param>
        /// <param name="lastOutputEventOn"> Value is either an ISO-8601 formatted timestamp indicating the last output event time of the streaming job or null indicating that output has not yet been produced. In case of multiple outputs or multiple streams, this shows the latest value in that set. </param>
        /// <param name="eventsOutOfOrderPolicy"> Indicates the policy to apply to events that arrive out of order in the input event stream. </param>
        /// <param name="outputErrorPolicy"> Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to being malformed (missing column values, column values of wrong type or size). </param>
        /// <param name="eventsOutOfOrderMaxDelayInSeconds"> The maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order. </param>
        /// <param name="eventsLateArrivalMaxDelayInSeconds"> The maximum tolerable delay in seconds where events arriving late could be included.  Supported range is -1 to 1814399 (20.23:59:59 days) and -1 is used to specify wait indefinitely. If the property is absent, it is interpreted to have a value of -1. </param>
        /// <param name="dataLocalion"> The data locale of the stream analytics job. Value should be the name of a supported .NET Culture from the set https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx. Defaults to 'en-US' if none specified. </param>
        /// <param name="compatibilityLevel"> Controls certain runtime behaviors of the streaming job. </param>
        /// <param name="createdOn"> Value is an ISO-8601 formatted UTC timestamp indicating when the streaming job was created. </param>
        /// <param name="inputs"> A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input. </param>
        /// <param name="transformation"> Indicates the query and the number of streaming units to use for the streaming job. The name property of the transformation is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation. </param>
        /// <param name="outputs"> A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output. </param>
        /// <param name="functions"> A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation. </param>
        /// <param name="etag"> The current entity tag for the streaming job. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency. </param>
        /// <param name="jobStorageAccount"> The properties that are associated with an Azure Storage account with MSI. </param>
        /// <param name="contentStoragePolicy"> Valid values are JobStorageAccount and SystemAccount. If set to JobStorageAccount, this requires the user to also specify jobStorageAccount property. . </param>
        /// <param name="externals"> The storage account where the custom code artifacts are located. </param>
        /// <param name="clusterId"> The cluster which streaming jobs will run on. </param>
        /// <returns> A new <see cref="StreamAnalytics.StreamingJobData"/> instance for mocking. </returns>
        public static StreamingJobData StreamingJobData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, StreamAnalyticsSkuName? skuName = null, Guid? jobId = null, string provisioningState = null, string jobState = null, StreamingJobType? jobType = null, StreamingJobOutputStartMode? outputStartMode = null, DateTimeOffset? outputStartOn = null, DateTimeOffset? lastOutputEventOn = null, EventsOutOfOrderPolicy? eventsOutOfOrderPolicy = null, StreamingJobOutputErrorPolicy? outputErrorPolicy = null, int? eventsOutOfOrderMaxDelayInSeconds = null, int? eventsLateArrivalMaxDelayInSeconds = null, AzureLocation? dataLocalion = null, StreamingJobCompatibilityLevel? compatibilityLevel = null, DateTimeOffset? createdOn = null, IEnumerable<StreamingJobInputData> inputs = null, StreamingJobTransformationData transformation = null, IEnumerable<StreamingJobOutputData> outputs = null, IEnumerable<StreamingJobFunctionData> functions = null, ETag? etag = null, StreamingJobStorageAccount jobStorageAccount = null, StreamingJobContentStoragePolicy? contentStoragePolicy = null, StreamingJobExternal externals = null, ResourceIdentifier clusterId = null)
        {
            tags ??= new Dictionary<string, string>();
            inputs ??= new List<StreamingJobInputData>();
            outputs ??= new List<StreamingJobOutputData>();
            functions ??= new List<StreamingJobFunctionData>();

            return new StreamingJobData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                skuName != null ? new StreamAnalyticsSku(skuName, serializedAdditionalRawData: null) : null,
                jobId,
                provisioningState,
                jobState,
                jobType,
                outputStartMode,
                outputStartOn,
                lastOutputEventOn,
                eventsOutOfOrderPolicy,
                outputErrorPolicy,
                eventsOutOfOrderMaxDelayInSeconds,
                eventsLateArrivalMaxDelayInSeconds,
                dataLocalion,
                compatibilityLevel,
                createdOn,
                inputs?.ToList(),
                transformation,
                outputs?.ToList(),
                functions?.ToList(),
                etag,
                jobStorageAccount,
                contentStoragePolicy,
                externals,
                clusterId != null ? new ClusterInfo(clusterId, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StreamAnalytics.StreamingJobTransformationData"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="streamingUnits"> Specifies the number of streaming units that the streaming job uses. </param>
        /// <param name="validStreamingUnits"> Specifies the valid streaming units a streaming job can scale to. </param>
        /// <param name="query"> Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="etag"> The current entity tag for the transformation. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency. </param>
        /// <returns> A new <see cref="StreamAnalytics.StreamingJobTransformationData"/> instance for mocking. </returns>
        public static StreamingJobTransformationData StreamingJobTransformationData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, int? streamingUnits = null, IEnumerable<int> validStreamingUnits = null, string query = null, ETag? etag = null)
        {
            validStreamingUnits ??= new List<int>();

            return new StreamingJobTransformationData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                streamingUnits,
                validStreamingUnits?.ToList(),
                query,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsSubscriptionQuota"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="maxCount"> The max permitted usage of this resource. </param>
        /// <param name="currentCount"> The current usage of this resource. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsSubscriptionQuota"/> instance for mocking. </returns>
        public static StreamAnalyticsSubscriptionQuota StreamAnalyticsSubscriptionQuota(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, int? maxCount = null, int? currentCount = null)
        {
            return new StreamAnalyticsSubscriptionQuota(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                maxCount,
                currentCount);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsTestQuery"/>. </summary>
        /// <param name="streamingJob"> Stream analytics job object which defines the input, output, and transformation for the query testing. </param>
        /// <param name="writeUri"> The SAS URI to the container or directory. </param>
        /// <param name="path"> The path to the subdirectory. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsTestQuery"/> instance for mocking. </returns>
        public static StreamAnalyticsTestQuery StreamAnalyticsTestQuery(StreamingJobData streamingJob = null, Uri writeUri = null, string path = null)
        {
            return new StreamAnalyticsTestQuery(streamingJob, writeUri, path, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsQueryTestingResult"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="target"> Error target. </param>
        /// <param name="details"> Error details. </param>
        /// <param name="status"> The status of the query testing request. </param>
        /// <param name="outputUri"> The SAS URL to the outputs payload. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsQueryTestingResult"/> instance for mocking. </returns>
        public static StreamAnalyticsQueryTestingResult StreamAnalyticsQueryTestingResult(string code = null, string message = null, string target = null, IEnumerable<StreamAnalyticsErrorDetails> details = null, StreamAnalyticsQueryTestingResultStatus? status = null, Uri outputUri = null)
        {
            details ??= new List<StreamAnalyticsErrorDetails>();

            return new StreamAnalyticsQueryTestingResult(
                code,
                message,
                target,
                details?.ToList(),
                serializedAdditionalRawData: null,
                status,
                outputUri);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsCompileQuery"/>. </summary>
        /// <param name="query"> The query to compile. </param>
        /// <param name="inputs"> The inputs for the query compilation. </param>
        /// <param name="functions"> The functions for the query compilation. </param>
        /// <param name="jobType"> Describes the type of the job. Valid values are `Cloud` and 'Edge'. </param>
        /// <param name="compatibilityLevel"> The query to compile. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsCompileQuery"/> instance for mocking. </returns>
        public static StreamAnalyticsCompileQuery StreamAnalyticsCompileQuery(string query = null, IEnumerable<StreamAnalyticsQueryInput> inputs = null, IEnumerable<StreamAnalyticsQueryFunction> functions = null, StreamingJobType jobType = default, StreamingJobCompatibilityLevel? compatibilityLevel = null)
        {
            inputs ??= new List<StreamAnalyticsQueryInput>();
            functions ??= new List<StreamAnalyticsQueryFunction>();

            return new StreamAnalyticsCompileQuery(
                query,
                inputs?.ToList(),
                functions?.ToList(),
                jobType,
                compatibilityLevel,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsQueryCompilationResult"/>. </summary>
        /// <param name="errors"> Error messages produced by the compiler. </param>
        /// <param name="warnings"> Warning messages produced by the compiler. </param>
        /// <param name="inputs"> All input names used by the query. </param>
        /// <param name="outputs"> All output names used by the query. </param>
        /// <param name="functions"> All function names used by the query. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsQueryCompilationResult"/> instance for mocking. </returns>
        public static StreamAnalyticsQueryCompilationResult StreamAnalyticsQueryCompilationResult(IEnumerable<StreamAnalyticsQueryCompilationError> errors = null, IEnumerable<string> warnings = null, IEnumerable<string> inputs = null, IEnumerable<string> outputs = null, IEnumerable<string> functions = null)
        {
            errors ??= new List<StreamAnalyticsQueryCompilationError>();
            warnings ??= new List<string>();
            inputs ??= new List<string>();
            outputs ??= new List<string>();
            functions ??= new List<string>();

            return new StreamAnalyticsQueryCompilationResult(
                errors?.ToList(),
                warnings?.ToList(),
                inputs?.ToList(),
                outputs?.ToList(),
                functions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsQueryCompilationError"/>. </summary>
        /// <param name="message"> The content of the error message. </param>
        /// <param name="startLine"> Describes the error location in the original query. Not set if isGlobal is true. </param>
        /// <param name="startColumn"> Describes the error location in the original query. Not set if isGlobal is true. </param>
        /// <param name="endLine"> Describes the error location in the original query. Not set if isGlobal is true. </param>
        /// <param name="endColumn"> Describes the error location in the original query. Not set if isGlobal is true. </param>
        /// <param name="isGlobal"> Whether the error is not for a specific part but for the entire query. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsQueryCompilationError"/> instance for mocking. </returns>
        public static StreamAnalyticsQueryCompilationError StreamAnalyticsQueryCompilationError(string message = null, int? startLine = null, int? startColumn = null, int? endLine = null, int? endColumn = null, bool? isGlobal = null)
        {
            return new StreamAnalyticsQueryCompilationError(
                message,
                startLine,
                startColumn,
                endLine,
                endColumn,
                isGlobal,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsSampleInputResult"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="target"> Error target. </param>
        /// <param name="details"> Error details. </param>
        /// <param name="status"> The status of the sample input request. </param>
        /// <param name="diagnostics"> Diagnostics messages. E.g. message indicating some partitions from the input have no data. </param>
        /// <param name="eventsDownloadUri"> A SAS URL to download the sampled input data. </param>
        /// <param name="lastArrivedOn"> The timestamp for the last event in the data. It is in DateTime format. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsSampleInputResult"/> instance for mocking. </returns>
        public static StreamAnalyticsSampleInputResult StreamAnalyticsSampleInputResult(string code = null, string message = null, string target = null, IEnumerable<StreamAnalyticsErrorDetails> details = null, StreamAnalyticsSampleInputResultStatus? status = null, IEnumerable<string> diagnostics = null, Uri eventsDownloadUri = null, DateTimeOffset? lastArrivedOn = null)
        {
            details ??= new List<StreamAnalyticsErrorDetails>();
            diagnostics ??= new List<string>();

            return new StreamAnalyticsSampleInputResult(
                code,
                message,
                target,
                details?.ToList(),
                serializedAdditionalRawData: null,
                status,
                diagnostics?.ToList(),
                eventsDownloadUri,
                lastArrivedOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsTestDatasourceResult"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="target"> Error target. </param>
        /// <param name="details"> Error details. </param>
        /// <param name="status"> The status of the sample output request. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsTestDatasourceResult"/> instance for mocking. </returns>
        public static StreamAnalyticsTestDatasourceResult StreamAnalyticsTestDatasourceResult(string code = null, string message = null, string target = null, IEnumerable<StreamAnalyticsErrorDetails> details = null, StreamAnalyticsTestDatasourceResultStatus? status = null)
        {
            details ??= new List<StreamAnalyticsErrorDetails>();

            return new StreamAnalyticsTestDatasourceResult(
                code,
                message,
                target,
                details?.ToList(),
                serializedAdditionalRawData: null,
                status);
        }

        /// <summary> Initializes a new instance of <see cref="StreamAnalytics.StreamAnalyticsClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests. </param>
        /// <param name="etag"> The current entity tag for the cluster. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency. </param>
        /// <param name="properties"> The properties associated with a Stream Analytics cluster. </param>
        /// <returns> A new <see cref="StreamAnalytics.StreamAnalyticsClusterData"/> instance for mocking. </returns>
        public static StreamAnalyticsClusterData StreamAnalyticsClusterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, StreamAnalyticsClusterSku sku = null, ETag? etag = null, StreamAnalyticsClusterProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new StreamAnalyticsClusterData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                sku,
                etag,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsClusterProperties"/>. </summary>
        /// <param name="createdOn"> The date this cluster was created. </param>
        /// <param name="clusterId"> Unique identifier for the cluster. </param>
        /// <param name="provisioningState"> The status of the cluster provisioning. The three terminal states are: Succeeded, Failed and Canceled. </param>
        /// <param name="capacityAllocated"> Represents the number of streaming units currently being used on the cluster. </param>
        /// <param name="capacityAssigned"> Represents the sum of the SUs of all streaming jobs associated with the cluster. If all of the jobs were running, this would be the capacity allocated. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsClusterProperties"/> instance for mocking. </returns>
        public static StreamAnalyticsClusterProperties StreamAnalyticsClusterProperties(DateTimeOffset? createdOn = null, Guid? clusterId = null, StreamAnalyticsClusterProvisioningState? provisioningState = null, int? capacityAllocated = null, int? capacityAssigned = null)
        {
            return new StreamAnalyticsClusterProperties(
                createdOn,
                clusterId,
                provisioningState,
                capacityAllocated,
                capacityAssigned,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsClusterJob"/>. </summary>
        /// <param name="id"> Resource ID of the streaming job. </param>
        /// <param name="streamingUnits"> The number of streaming units that are used by the streaming job. </param>
        /// <param name="jobState"> The current execution state of the streaming job. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsClusterJob"/> instance for mocking. </returns>
        public static StreamAnalyticsClusterJob StreamAnalyticsClusterJob(ResourceIdentifier id = null, int? streamingUnits = null, StreamingJobState? jobState = null)
        {
            return new StreamAnalyticsClusterJob(id, streamingUnits, jobState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StreamAnalytics.StreamAnalyticsPrivateEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The properties associated with a private endpoint. </param>
        /// <param name="etag"> Unique opaque string (generally a GUID) that represents the metadata state of the resource (private endpoint) and changes whenever the resource is updated. Required on PUT (CreateOrUpdate) requests. </param>
        /// <returns> A new <see cref="StreamAnalytics.StreamAnalyticsPrivateEndpointData"/> instance for mocking. </returns>
        public static StreamAnalyticsPrivateEndpointData StreamAnalyticsPrivateEndpointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, StreamAnalyticsPrivateEndpointProperties properties = null, ETag? etag = null)
        {
            return new StreamAnalyticsPrivateEndpointData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsPrivateEndpointProperties"/>. </summary>
        /// <param name="createdOn"> The date when this private endpoint was created. </param>
        /// <param name="manualPrivateLinkServiceConnections"> A list of connections to the remote resource. Immutable after it is set. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsPrivateEndpointProperties"/> instance for mocking. </returns>
        public static StreamAnalyticsPrivateEndpointProperties StreamAnalyticsPrivateEndpointProperties(DateTimeOffset? createdOn = null, IEnumerable<StreamAnalyticsPrivateLinkServiceConnection> manualPrivateLinkServiceConnections = null)
        {
            manualPrivateLinkServiceConnections ??= new List<StreamAnalyticsPrivateLinkServiceConnection>();

            return new StreamAnalyticsPrivateEndpointProperties(createdOn, manualPrivateLinkServiceConnections?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsPrivateLinkServiceConnection"/>. </summary>
        /// <param name="privateLinkServiceId"> The resource id of the private link service. Required on PUT (CreateOrUpdate) requests. </param>
        /// <param name="groupIds"> The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT (CreateOrUpdate) requests. </param>
        /// <param name="requestMessage"> A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars. </param>
        /// <param name="privateLinkServiceConnectionState"> A collection of read-only information about the state of the connection to the private remote resource. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsPrivateLinkServiceConnection"/> instance for mocking. </returns>
        public static StreamAnalyticsPrivateLinkServiceConnection StreamAnalyticsPrivateLinkServiceConnection(ResourceIdentifier privateLinkServiceId = null, IEnumerable<string> groupIds = null, string requestMessage = null, StreamAnalyticsPrivateLinkConnectionState privateLinkServiceConnectionState = null)
        {
            groupIds ??= new List<string>();

            return new StreamAnalyticsPrivateLinkServiceConnection(privateLinkServiceId, groupIds?.ToList(), requestMessage, privateLinkServiceConnectionState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamAnalyticsPrivateLinkConnectionState"/>. </summary>
        /// <param name="status"> Indicates whether the connection has been Approved/Rejected/Removed by the owner of the remote resource/service. </param>
        /// <param name="description"> The reason for approval/rejection of the connection. </param>
        /// <param name="actionsRequired"> A message indicating if changes on the service provider require any updates on the consumer. </param>
        /// <returns> A new <see cref="Models.StreamAnalyticsPrivateLinkConnectionState"/> instance for mocking. </returns>
        public static StreamAnalyticsPrivateLinkConnectionState StreamAnalyticsPrivateLinkConnectionState(string status = null, string description = null, string actionsRequired = null)
        {
            return new StreamAnalyticsPrivateLinkConnectionState(status, description, actionsRequired, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ScalarFunctionProperties"/>. </summary>
        /// <param name="etag"> The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency. </param>
        /// <param name="inputs"></param>
        /// <param name="outputDataType"> Describes the output of a function. </param>
        /// <param name="binding">
        /// The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
        /// Please note <see cref="StreamingJobFunctionBinding"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="EMachineLearningStudioFunctionBinding"/>, <see cref="MachineLearningServiceFunctionBinding"/>, <see cref="CSharpFunctionBinding"/> and <see cref="JavaScriptFunctionBinding"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ScalarFunctionProperties"/> instance for mocking. </returns>
        public static ScalarFunctionProperties ScalarFunctionProperties(ETag? etag = null, IEnumerable<StreamingJobFunctionInput> inputs = null, string outputDataType = null, StreamingJobFunctionBinding binding = null)
        {
            inputs ??= new List<StreamingJobFunctionInput>();

            return new ScalarFunctionProperties(
                "Scalar",
                etag,
                inputs?.ToList(),
                outputDataType != null ? new StreamingJobFunctionOutput(outputDataType, serializedAdditionalRawData: null) : null,
                binding,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AggregateFunctionProperties"/>. </summary>
        /// <param name="etag"> The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency. </param>
        /// <param name="inputs"></param>
        /// <param name="outputDataType"> Describes the output of a function. </param>
        /// <param name="binding">
        /// The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
        /// Please note <see cref="StreamingJobFunctionBinding"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="EMachineLearningStudioFunctionBinding"/>, <see cref="MachineLearningServiceFunctionBinding"/>, <see cref="CSharpFunctionBinding"/> and <see cref="JavaScriptFunctionBinding"/>.
        /// </param>
        /// <returns> A new <see cref="Models.AggregateFunctionProperties"/> instance for mocking. </returns>
        public static AggregateFunctionProperties AggregateFunctionProperties(ETag? etag = null, IEnumerable<StreamingJobFunctionInput> inputs = null, string outputDataType = null, StreamingJobFunctionBinding binding = null)
        {
            inputs ??= new List<StreamingJobFunctionInput>();

            return new AggregateFunctionProperties(
                "Aggregate",
                etag,
                inputs?.ToList(),
                outputDataType != null ? new StreamingJobFunctionOutput(outputDataType, serializedAdditionalRawData: null) : null,
                binding,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamInputProperties"/>. </summary>
        /// <param name="serialization">
        /// Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        /// Please note <see cref="StreamAnalyticsDataSerialization"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AvroFormatSerialization"/>, <see cref="CsvFormatSerialization"/>, <see cref="CustomClrFormatSerialization"/>, <see cref="JsonFormatSerialization"/> and <see cref="ParquetFormatSerialization"/>.
        /// </param>
        /// <param name="diagnosticsConditions"> Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention. </param>
        /// <param name="etag"> The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency. </param>
        /// <param name="compressionType"> Describes how input data is compressed. </param>
        /// <param name="partitionKey"> partitionKey Describes a key in the input data which is used for partitioning the input data. </param>
        /// <param name="watermarkMode"> Settings which determine whether to read watermark events. </param>
        /// <param name="datasource">
        /// Describes an input data source that contains stream data. Required on PUT (CreateOrReplace) requests.
        /// Please note <see cref="StreamInputDataSource"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="GatewayMessageBusStreamInputDataSource"/>, <see cref="IoTHubStreamInputDataSource"/>, <see cref="EventGridStreamInputDataSource"/>, <see cref="EventHubV2StreamInputDataSource"/>, <see cref="EventHubStreamInputDataSource"/>, <see cref="BlobStreamInputDataSource"/> and <see cref="RawStreamInputDataSource"/>.
        /// </param>
        /// <returns> A new <see cref="Models.StreamInputProperties"/> instance for mocking. </returns>
        public static StreamInputProperties StreamInputProperties(StreamAnalyticsDataSerialization serialization = null, IEnumerable<StreamingJobDiagnosticCondition> diagnosticsConditions = null, ETag? etag = null, StreamingCompressionType? compressionType = null, string partitionKey = null, StreamingJobInputWatermarkMode? watermarkMode = null, StreamInputDataSource datasource = null)
        {
            diagnosticsConditions ??= new List<StreamingJobDiagnosticCondition>();

            return new StreamInputProperties(
                "Stream",
                serialization,
                diagnosticsConditions != null ? new StreamingJobDiagnostics(diagnosticsConditions?.ToList(), serializedAdditionalRawData: null) : null,
                etag,
                compressionType.HasValue ? new StreamingCompression(compressionType.Value, serializedAdditionalRawData: null) : null,
                partitionKey,
                watermarkMode != null ? new StreamingJobInputWatermarkProperties(watermarkMode, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null,
                datasource);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ReferenceInputProperties"/>. </summary>
        /// <param name="serialization">
        /// Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        /// Please note <see cref="StreamAnalyticsDataSerialization"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AvroFormatSerialization"/>, <see cref="CsvFormatSerialization"/>, <see cref="CustomClrFormatSerialization"/>, <see cref="JsonFormatSerialization"/> and <see cref="ParquetFormatSerialization"/>.
        /// </param>
        /// <param name="diagnosticsConditions"> Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention. </param>
        /// <param name="etag"> The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency. </param>
        /// <param name="compressionType"> Describes how input data is compressed. </param>
        /// <param name="partitionKey"> partitionKey Describes a key in the input data which is used for partitioning the input data. </param>
        /// <param name="watermarkMode"> Settings which determine whether to read watermark events. </param>
        /// <param name="datasource">
        /// Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
        /// Please note <see cref="ReferenceInputDataSource"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SqlReferenceInputDataSource"/>, <see cref="BlobReferenceInputDataSource"/> and <see cref="RawReferenceInputDataSource"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ReferenceInputProperties"/> instance for mocking. </returns>
        public static ReferenceInputProperties ReferenceInputProperties(StreamAnalyticsDataSerialization serialization = null, IEnumerable<StreamingJobDiagnosticCondition> diagnosticsConditions = null, ETag? etag = null, StreamingCompressionType? compressionType = null, string partitionKey = null, StreamingJobInputWatermarkMode? watermarkMode = null, ReferenceInputDataSource datasource = null)
        {
            diagnosticsConditions ??= new List<StreamingJobDiagnosticCondition>();

            return new ReferenceInputProperties(
                "Reference",
                serialization,
                diagnosticsConditions != null ? new StreamingJobDiagnostics(diagnosticsConditions?.ToList(), serializedAdditionalRawData: null) : null,
                etag,
                compressionType.HasValue ? new StreamingCompression(compressionType.Value, serializedAdditionalRawData: null) : null,
                partitionKey,
                watermarkMode != null ? new StreamingJobInputWatermarkProperties(watermarkMode, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null,
                datasource);
        }
    }
}
