// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.StreamAnalytics.Samples
{
    public partial class Sample_StreamingJobTransformationCollection
    {
        // Create a transformation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateATransformation()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Transformation_Create.json
            // this example is just showing the usage of "Transformations_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg4423";
            string jobName = "sj8374";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobTransformationResource
            StreamingJobTransformationCollection collection = streamingJob.GetStreamingJobTransformations();

            // invoke the operation
            string transformationName = "transformation952";
            StreamingJobTransformationData data = new StreamingJobTransformationData()
            {
                StreamingUnits = 6,
                Query = "Select Id, Name from inputtest",
            };
            ArmOperation<StreamingJobTransformationResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, transformationName, data);
            StreamingJobTransformationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobTransformationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a transformation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetATransformation()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Transformation_Get.json
            // this example is just showing the usage of "Transformations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg4423";
            string jobName = "sj8374";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobTransformationResource
            StreamingJobTransformationCollection collection = streamingJob.GetStreamingJobTransformations();

            // invoke the operation
            string transformationName = "transformation952";
            StreamingJobTransformationResource result = await collection.GetAsync(transformationName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobTransformationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a transformation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetATransformation()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Transformation_Get.json
            // this example is just showing the usage of "Transformations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg4423";
            string jobName = "sj8374";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobTransformationResource
            StreamingJobTransformationCollection collection = streamingJob.GetStreamingJobTransformations();

            // invoke the operation
            string transformationName = "transformation952";
            bool result = await collection.ExistsAsync(transformationName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a transformation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetATransformation()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Transformation_Get.json
            // this example is just showing the usage of "Transformations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg4423";
            string jobName = "sj8374";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobTransformationResource
            StreamingJobTransformationCollection collection = streamingJob.GetStreamingJobTransformations();

            // invoke the operation
            string transformationName = "transformation952";
            NullableResponse<StreamingJobTransformationResource> response = await collection.GetIfExistsAsync(transformationName);
            StreamingJobTransformationResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobTransformationData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
