// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.StreamAnalytics.Models;

namespace Azure.ResourceManager.StreamAnalytics.Samples
{
    public partial class Sample_StreamingJobOutputResource
    {
        // Update a DocumentDB output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateADocumentDBOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_DocumentDB.json
            // this example is just showing the usage of "Outputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            string outputName = "output3022";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new DocumentDbOutputDataSource()
                {
                    PartitionKey = "differentPartitionKey",
                },
            };
            StreamingJobOutputResource result = await streamingJobOutput.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a Power BI output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAPowerBIOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_PowerBI.json
            // this example is just showing the usage of "Outputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            string outputName = "output3022";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new PowerBIOutputDataSource()
                {
                    Dataset = "differentDataset",
                },
            };
            StreamingJobOutputResource result = await streamingJobOutput.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a Service Bus Queue output with Avro serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAServiceBusQueueOutputWithAvroSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_ServiceBusQueue.json
            // this example is just showing the usage of "Outputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3410";
            string jobName = "sj5095";
            string outputName = "output3456";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new ServiceBusQueueOutputDataSource()
                {
                    QueueName = "differentQueueName",
                },
                Serialization = new JsonFormatSerialization()
                {
                    Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                    Format = JsonOutputSerializationFormat.LineSeparated,
                },
            };
            StreamingJobOutputResource result = await streamingJobOutput.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a Service Bus Topic output with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAServiceBusTopicOutputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_ServiceBusTopic.json
            // this example is just showing the usage of "Outputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6450";
            string jobName = "sj7094";
            string outputName = "output7886";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new ServiceBusTopicOutputDataSource()
                {
                    TopicName = "differentTopicName",
                },
                Serialization = new CsvFormatSerialization()
                {
                    FieldDelimiter = "|",
                    Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                },
            };
            StreamingJobOutputResource result = await streamingJobOutput.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a blob output with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateABlobOutputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_Blob.json
            // this example is just showing the usage of "Outputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg5023";
            string jobName = "sj900";
            string outputName = "output1623";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new BlobOutputDataSource()
                {
                    Container = "differentContainer",
                },
                Serialization = new CsvFormatSerialization()
                {
                    FieldDelimiter = "|",
                    Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                },
            };
            StreamingJobOutputResource result = await streamingJobOutput.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update an Azure Data Lake Store output with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAnAzureDataLakeStoreOutputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_AzureDataLakeStore.json
            // this example is just showing the usage of "Outputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6912";
            string jobName = "sj3310";
            string outputName = "output5195";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new DataLakeStoreOutputDataSource()
                {
                    AccountName = "differentaccount",
                },
                Serialization = new JsonFormatSerialization()
                {
                    Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                    Format = JsonOutputSerializationFormat.LineSeparated,
                },
            };
            StreamingJobOutputResource result = await streamingJobOutput.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update an Azure Data Warehouse output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAnAzureDataWarehouseOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_DataWarehouse.json
            // this example is just showing the usage of "Outputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg";
            string jobName = "sjName";
            string outputName = "dwOutput";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new SqlDatabaseOutputDataSource()
                {
                    Table = "differentTable",
                },
            };
            StreamingJobOutputResource result = await streamingJobOutput.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update an Azure Function output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAnAzureFunctionOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_AzureFunction.json
            // this example is just showing the usage of "Outputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg";
            string jobName = "sjName";
            string outputName = "azureFunction1";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new FunctionOutputDataSource()
                {
                    FunctionName = "differentFunctionName",
                },
            };
            StreamingJobOutputResource result = await streamingJobOutput.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update an Azure SQL database output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAnAzureSQLDatabaseOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_AzureSQL.json
            // this example is just showing the usage of "Outputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg2157";
            string jobName = "sj6458";
            string outputName = "output1755";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new SqlDatabaseOutputDataSource()
                {
                    Table = "differentTable",
                },
            };
            StreamingJobOutputResource result = await streamingJobOutput.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update an Azure Table output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAnAzureTableOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_AzureTable.json
            // this example is just showing the usage of "Outputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg5176";
            string jobName = "sj2790";
            string outputName = "output958";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new TableOutputDataSource()
                {
                    PartitionKey = "differentPartitionKey",
                },
            };
            StreamingJobOutputResource result = await streamingJobOutput.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update an Event Hub output with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAnEventHubOutputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_EventHub.json
            // this example is just showing the usage of "Outputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6912";
            string jobName = "sj3310";
            string outputName = "output5195";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new EventHubOutputDataSource()
                {
                    PartitionKey = "differentPartitionKey",
                },
                Serialization = new JsonFormatSerialization()
                {
                    Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                    Format = JsonOutputSerializationFormat.LineSeparated,
                },
            };
            StreamingJobOutputResource result = await streamingJobOutput.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete an output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAnOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Delete.json
            // this example is just showing the usage of "Outputs_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg2157";
            string jobName = "sj6458";
            string outputName = "output1755";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            await streamingJobOutput.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get a DocumentDB output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetADocumentDBOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_DocumentDB.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            string outputName = "output3022";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputResource result = await streamingJobOutput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a Power BI output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAPowerBIOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_PowerBI.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            string outputName = "output3022";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputResource result = await streamingJobOutput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a Service Bus Queue output with Avro serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAServiceBusQueueOutputWithAvroSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_ServiceBusQueue_Avro.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3410";
            string jobName = "sj5095";
            string outputName = "output3456";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputResource result = await streamingJobOutput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a Service Bus Topic output with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAServiceBusTopicOutputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_ServiceBusTopic_CSV.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6450";
            string jobName = "sj7094";
            string outputName = "output7886";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputResource result = await streamingJobOutput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a blob output with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetABlobOutputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_Blob_CSV.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg5023";
            string jobName = "sj900";
            string outputName = "output1623";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputResource result = await streamingJobOutput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an Azure Data Lake Store output with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAzureDataLakeStoreOutputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureDataLakeStore_JSON.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6912";
            string jobName = "sj3310";
            string outputName = "output5195";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputResource result = await streamingJobOutput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an Azure Data Warehouse output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAzureDataWarehouseOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_DataWarehouse.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg";
            string jobName = "sjName";
            string outputName = "dwOutput";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputResource result = await streamingJobOutput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an Azure Function output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAzureFunctionOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureFunction.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg";
            string jobName = "sjName";
            string outputName = "azureFunction1";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputResource result = await streamingJobOutput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an Azure SQL database output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAzureSQLDatabaseOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureSQL.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg2157";
            string jobName = "sj6458";
            string outputName = "output1755";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputResource result = await streamingJobOutput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an Azure Table output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAzureTableOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureTable.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg5176";
            string jobName = "sj2790";
            string outputName = "output958";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputResource result = await streamingJobOutput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an Event Hub output with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnEventHubOutputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_EventHub_JSON.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6912";
            string jobName = "sj3310";
            string outputName = "output5195";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            StreamingJobOutputResource result = await streamingJobOutput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Test the connection for an output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Test_TestTheConnectionForAnOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Test.json
            // this example is just showing the usage of "Outputs_Test" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobOutputResource created on azure
            // for more information of creating StreamingJobOutputResource, please refer to the document of StreamingJobOutputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg2157";
            string jobName = "sj6458";
            string outputName = "output1755";
            ResourceIdentifier streamingJobOutputResourceId = StreamingJobOutputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, outputName);
            StreamingJobOutputResource streamingJobOutput = client.GetStreamingJobOutputResource(streamingJobOutputResourceId);

            // invoke the operation
            ArmOperation<StreamAnalyticsResourceTestStatus> lro = await streamingJobOutput.TestAsync(WaitUntil.Completed);
            StreamAnalyticsResourceTestStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
