// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.StreamAnalytics.Models;

namespace Azure.ResourceManager.StreamAnalytics.Samples
{
    public partial class Sample_StreamingJobOutputCollection
    {
        // Create a DocumentDB output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateADocumentDBOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_DocumentDB.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3022";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new DocumentDbOutputDataSource()
                {
                    AccountId = "someAccountId",
                    AccountKey = "accountKey==",
                    Database = "db01",
                    CollectionNamePattern = "collection",
                    PartitionKey = "key",
                    DocumentId = "documentId",
                    AuthenticationMode = StreamAnalyticsAuthenticationMode.Msi,
                },
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a Gateway Message Bus output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAGatewayMessageBusOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_GatewayMessageBus.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3022";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new GatewayMessageBusOutputDataSource()
                {
                    Topic = "EdgeTopic1",
                },
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a PostgreSQL output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAPostgreSQLOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_PostgreSQL.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3022";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new PostgreSQLOutputDataSource()
                {
                    Server = "someServer",
                    Database = "someDatabase",
                    Table = "someTable",
                    User = "user",
                    Password = "somePassword",
                    MaxWriterCount = 1,
                    AuthenticationMode = StreamAnalyticsAuthenticationMode.Msi,
                },
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a Power BI output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAPowerBIOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_PowerBI.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3022";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new PowerBIOutputDataSource()
                {
                    RefreshToken = "someRefreshToken==",
                    TokenUserPrincipalName = "bobsmith@contoso.com",
                    TokenUserDisplayName = "Bob Smith",
                    Dataset = "someDataset",
                    Table = "someTable",
                    GroupId = Guid.Parse("ac40305e-3e8d-43ac-8161-c33799f43e95"),
                    GroupName = "MyPowerBIGroup",
                },
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a Service Bus Queue output with Avro serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAServiceBusQueueOutputWithAvroSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_ServiceBusQueue_Avro.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3410";
            string jobName = "sj5095";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3456";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new ServiceBusQueueOutputDataSource()
                {
                    ServiceBusNamespace = "sdktest",
                    SharedAccessPolicyName = "RootManageSharedAccessKey",
                    SharedAccessPolicyKey = "sharedAccessPolicyKey=",
                    QueueName = "sdkqueue",
                    PropertyColumns =
{
"column1","column2"
},
                    SystemPropertyColumns =
{
["MessageId"] = "col3",
["PartitionKey"] = "col4",
},
                },
                Serialization = new AvroFormatSerialization(),
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a Service Bus Topic output with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAServiceBusTopicOutputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_ServiceBusTopic_CSV.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6450";
            string jobName = "sj7094";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output7886";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new ServiceBusTopicOutputDataSource()
                {
                    ServiceBusNamespace = "sdktest",
                    SharedAccessPolicyName = "RootManageSharedAccessKey",
                    SharedAccessPolicyKey = "sharedAccessPolicyKey=",
                    TopicName = "sdktopic",
                    PropertyColumns =
{
"column1","column2"
},
                },
                Serialization = new CsvFormatSerialization()
                {
                    FieldDelimiter = ",",
                    Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                },
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a blob output with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateABlobOutputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_Blob_CSV.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg5023";
            string jobName = "sj900";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output1623";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new BlobOutputDataSource()
                {
                    StorageAccounts =
{
new StreamAnalyticsStorageAccount()
{
AccountName = "someAccountName",
AccountKey = "accountKey==",
}
},
                    Container = "state",
                    PathPattern = "{date}/{time}",
                    DateFormat = "yyyy/MM/dd",
                    TimeFormat = "HH",
                    BlobPathPrefix = "my/path",
                    BlobWriteMode = BlobOutputWriteMode.Once,
                },
                Serialization = new CsvFormatSerialization()
                {
                    FieldDelimiter = ",",
                    Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                },
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create an Azure Data Lake Store output with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAnAzureDataLakeStoreOutputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_AzureDataLakeStore_JSON.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6912";
            string jobName = "sj3310";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output5195";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new DataLakeStoreOutputDataSource()
                {
                    RefreshToken = "someRefreshToken==",
                    TokenUserPrincipalName = "bobsmith@contoso.com",
                    TokenUserDisplayName = "Bob Smith",
                    AccountName = "someaccount",
                    TenantId = Guid.Parse("cea4e98b-c798-49e7-8c40-4a2b3beb47dd"),
                    FilePathPrefix = "{date}/{time}",
                    DateFormat = "yyyy/MM/dd",
                    TimeFormat = "HH",
                },
                Serialization = new JsonFormatSerialization()
                {
                    Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                    Format = JsonOutputSerializationFormat.Array,
                },
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create an Azure Data Warehouse output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAnAzureDataWarehouseOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_DataWarehouse.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg";
            string jobName = "sjName";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "dwOutput";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new SynapseOutputDataSource()
                {
                    Server = "asatestserver",
                    Database = "zhayaSQLpool",
                    Table = "test2",
                    User = "tolladmin",
                    Password = "password123",
                    AuthenticationMode = StreamAnalyticsAuthenticationMode.Msi,
                },
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create an Azure Function output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAnAzureFunctionOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_AzureFunction.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg";
            string jobName = "sjName";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "azureFunction1";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new FunctionOutputDataSource()
                {
                    FunctionAppName = "functionappforasaautomation",
                    FunctionName = "HttpTrigger2",
                    ApiKey = null,
                    MaxBatchSize = 256,
                    MaxBatchCount = 100,
                },
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create an Azure SQL database output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAnAzureSQLDatabaseOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_AzureSQL.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg2157";
            string jobName = "sj6458";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output1755";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new SqlDatabaseOutputDataSource()
                {
                    Server = "someServer",
                    Database = "someDatabase",
                    User = "<user>",
                    Password = "somePassword",
                    Table = "someTable",
                },
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create an Azure Table output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAnAzureTableOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_AzureTable.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg5176";
            string jobName = "sj2790";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output958";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new TableOutputDataSource()
                {
                    AccountName = "someAccountName",
                    AccountKey = "accountKey==",
                    Table = "samples",
                    PartitionKey = "partitionKey",
                    RowKey = "rowKey",
                    ColumnsToRemove =
{
"column1","column2"
},
                    BatchSize = 25,
                },
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create an Event Hub output with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAnEventHubOutputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_EventHub_JSON.json
            // this example is just showing the usage of "Outputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6912";
            string jobName = "sj3310";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output5195";
            StreamingJobOutputData data = new StreamingJobOutputData()
            {
                Datasource = new EventHubOutputDataSource()
                {
                    ServiceBusNamespace = "sdktest",
                    SharedAccessPolicyName = "RootManageSharedAccessKey",
                    SharedAccessPolicyKey = "sharedAccessPolicyKey=",
                    EventHubName = "sdkeventhub",
                    PartitionKey = "partitionKey",
                },
                Serialization = new JsonFormatSerialization()
                {
                    Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                    Format = JsonOutputSerializationFormat.Array,
                },
                WatermarkSettings = new StreamingJobOutputWatermarkProperties()
                {
                    WatermarkMode = StreamingJobOutputWatermarkMode.SendCurrentPartitionWatermark,
                    MaxWatermarkDifferenceAcrossPartitions = "16:14:30",
                },
            };
            ArmOperation<StreamingJobOutputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, outputName, data);
            StreamingJobOutputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a DocumentDB output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetADocumentDBOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_DocumentDB.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3022";
            StreamingJobOutputResource result = await collection.GetAsync(outputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a DocumentDB output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetADocumentDBOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_DocumentDB.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3022";
            bool result = await collection.ExistsAsync(outputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a DocumentDB output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetADocumentDBOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_DocumentDB.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3022";
            NullableResponse<StreamingJobOutputResource> response = await collection.GetIfExistsAsync(outputName);
            StreamingJobOutputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobOutputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get a Power BI output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAPowerBIOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_PowerBI.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3022";
            StreamingJobOutputResource result = await collection.GetAsync(outputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a Power BI output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAPowerBIOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_PowerBI.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3022";
            bool result = await collection.ExistsAsync(outputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a Power BI output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAPowerBIOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_PowerBI.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg7983";
            string jobName = "sj2331";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3022";
            NullableResponse<StreamingJobOutputResource> response = await collection.GetIfExistsAsync(outputName);
            StreamingJobOutputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobOutputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get a Service Bus Queue output with Avro serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAServiceBusQueueOutputWithAvroSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_ServiceBusQueue_Avro.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3410";
            string jobName = "sj5095";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3456";
            StreamingJobOutputResource result = await collection.GetAsync(outputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a Service Bus Queue output with Avro serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAServiceBusQueueOutputWithAvroSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_ServiceBusQueue_Avro.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3410";
            string jobName = "sj5095";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3456";
            bool result = await collection.ExistsAsync(outputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a Service Bus Queue output with Avro serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAServiceBusQueueOutputWithAvroSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_ServiceBusQueue_Avro.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3410";
            string jobName = "sj5095";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output3456";
            NullableResponse<StreamingJobOutputResource> response = await collection.GetIfExistsAsync(outputName);
            StreamingJobOutputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobOutputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get a Service Bus Topic output with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAServiceBusTopicOutputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_ServiceBusTopic_CSV.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6450";
            string jobName = "sj7094";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output7886";
            StreamingJobOutputResource result = await collection.GetAsync(outputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a Service Bus Topic output with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAServiceBusTopicOutputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_ServiceBusTopic_CSV.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6450";
            string jobName = "sj7094";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output7886";
            bool result = await collection.ExistsAsync(outputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a Service Bus Topic output with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAServiceBusTopicOutputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_ServiceBusTopic_CSV.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6450";
            string jobName = "sj7094";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output7886";
            NullableResponse<StreamingJobOutputResource> response = await collection.GetIfExistsAsync(outputName);
            StreamingJobOutputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobOutputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get a blob output with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetABlobOutputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_Blob_CSV.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg5023";
            string jobName = "sj900";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output1623";
            StreamingJobOutputResource result = await collection.GetAsync(outputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a blob output with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetABlobOutputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_Blob_CSV.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg5023";
            string jobName = "sj900";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output1623";
            bool result = await collection.ExistsAsync(outputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a blob output with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetABlobOutputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_Blob_CSV.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg5023";
            string jobName = "sj900";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output1623";
            NullableResponse<StreamingJobOutputResource> response = await collection.GetIfExistsAsync(outputName);
            StreamingJobOutputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobOutputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get an Azure Data Lake Store output with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAzureDataLakeStoreOutputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureDataLakeStore_JSON.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6912";
            string jobName = "sj3310";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output5195";
            StreamingJobOutputResource result = await collection.GetAsync(outputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an Azure Data Lake Store output with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAnAzureDataLakeStoreOutputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureDataLakeStore_JSON.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6912";
            string jobName = "sj3310";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output5195";
            bool result = await collection.ExistsAsync(outputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get an Azure Data Lake Store output with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAnAzureDataLakeStoreOutputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureDataLakeStore_JSON.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6912";
            string jobName = "sj3310";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output5195";
            NullableResponse<StreamingJobOutputResource> response = await collection.GetIfExistsAsync(outputName);
            StreamingJobOutputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobOutputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get an Azure Data Warehouse output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAzureDataWarehouseOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_DataWarehouse.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg";
            string jobName = "sjName";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "dwOutput";
            StreamingJobOutputResource result = await collection.GetAsync(outputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an Azure Data Warehouse output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAnAzureDataWarehouseOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_DataWarehouse.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg";
            string jobName = "sjName";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "dwOutput";
            bool result = await collection.ExistsAsync(outputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get an Azure Data Warehouse output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAnAzureDataWarehouseOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_DataWarehouse.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg";
            string jobName = "sjName";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "dwOutput";
            NullableResponse<StreamingJobOutputResource> response = await collection.GetIfExistsAsync(outputName);
            StreamingJobOutputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobOutputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get an Azure Function output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAzureFunctionOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureFunction.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg";
            string jobName = "sjName";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "azureFunction1";
            StreamingJobOutputResource result = await collection.GetAsync(outputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an Azure Function output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAnAzureFunctionOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureFunction.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg";
            string jobName = "sjName";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "azureFunction1";
            bool result = await collection.ExistsAsync(outputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get an Azure Function output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAnAzureFunctionOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureFunction.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg";
            string jobName = "sjName";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "azureFunction1";
            NullableResponse<StreamingJobOutputResource> response = await collection.GetIfExistsAsync(outputName);
            StreamingJobOutputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobOutputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get an Azure SQL database output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAzureSQLDatabaseOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureSQL.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg2157";
            string jobName = "sj6458";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output1755";
            StreamingJobOutputResource result = await collection.GetAsync(outputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an Azure SQL database output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAnAzureSQLDatabaseOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureSQL.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg2157";
            string jobName = "sj6458";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output1755";
            bool result = await collection.ExistsAsync(outputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get an Azure SQL database output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAnAzureSQLDatabaseOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureSQL.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg2157";
            string jobName = "sj6458";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output1755";
            NullableResponse<StreamingJobOutputResource> response = await collection.GetIfExistsAsync(outputName);
            StreamingJobOutputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobOutputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get an Azure Table output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAzureTableOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureTable.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg5176";
            string jobName = "sj2790";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output958";
            StreamingJobOutputResource result = await collection.GetAsync(outputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an Azure Table output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAnAzureTableOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureTable.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg5176";
            string jobName = "sj2790";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output958";
            bool result = await collection.ExistsAsync(outputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get an Azure Table output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAnAzureTableOutput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureTable.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg5176";
            string jobName = "sj2790";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output958";
            NullableResponse<StreamingJobOutputResource> response = await collection.GetIfExistsAsync(outputName);
            StreamingJobOutputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobOutputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get an Event Hub output with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnEventHubOutputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_EventHub_JSON.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6912";
            string jobName = "sj3310";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output5195";
            StreamingJobOutputResource result = await collection.GetAsync(outputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobOutputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an Event Hub output with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAnEventHubOutputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_EventHub_JSON.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6912";
            string jobName = "sj3310";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output5195";
            bool result = await collection.ExistsAsync(outputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get an Event Hub output with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAnEventHubOutputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_EventHub_JSON.json
            // this example is just showing the usage of "Outputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg6912";
            string jobName = "sj3310";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation
            string outputName = "output5195";
            NullableResponse<StreamingJobOutputResource> response = await collection.GetIfExistsAsync(outputName);
            StreamingJobOutputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobOutputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List all outputs in a streaming job
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListAllOutputsInAStreamingJob()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_ListByStreamingJob.json
            // this example is just showing the usage of "Outputs_ListByStreamingJob" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg2157";
            string jobName = "sj6458";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobOutputResource
            StreamingJobOutputCollection collection = streamingJob.GetStreamingJobOutputs();

            // invoke the operation and iterate over the result
            await foreach (StreamingJobOutputResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobOutputData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
