// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.StreamAnalytics.Models;

namespace Azure.ResourceManager.StreamAnalytics.Samples
{
    public partial class Sample_StreamingJobInputResource
    {
        // Update a reference blob input
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAReferenceBlobInput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Update_Reference_Blob.json
            // this example is just showing the usage of "Inputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobInputResource created on azure
            // for more information of creating StreamingJobInputResource, please refer to the document of StreamingJobInputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8440";
            string jobName = "sj9597";
            string inputName = "input7225";
            ResourceIdentifier streamingJobInputResourceId = StreamingJobInputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, inputName);
            StreamingJobInputResource streamingJobInput = client.GetStreamingJobInputResource(streamingJobInputResourceId);

            // invoke the operation
            StreamingJobInputData input = new StreamingJobInputData()
            {
                Properties = new ReferenceInputProperties()
                {
                    Datasource = new BlobReferenceInputDataSource()
                    {
                        Container = "differentContainer",
                    },
                    Serialization = new CsvFormatSerialization()
                    {
                        FieldDelimiter = "|",
                        Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                    },
                },
            };
            StreamingJobInputResource result = await streamingJobInput.UpdateAsync(input);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a stream Event Hub input
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAStreamEventHubInput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Update_Stream_EventHub.json
            // this example is just showing the usage of "Inputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobInputResource created on azure
            // for more information of creating StreamingJobInputResource, please refer to the document of StreamingJobInputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3139";
            string jobName = "sj197";
            string inputName = "input7425";
            ResourceIdentifier streamingJobInputResourceId = StreamingJobInputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, inputName);
            StreamingJobInputResource streamingJobInput = client.GetStreamingJobInputResource(streamingJobInputResourceId);

            // invoke the operation
            StreamingJobInputData input = new StreamingJobInputData()
            {
                Properties = new StreamInputProperties()
                {
                    Datasource = new EventHubStreamInputDataSource()
                    {
                        ConsumerGroupName = "differentConsumerGroupName",
                    },
                    Serialization = new AvroFormatSerialization(),
                },
            };
            StreamingJobInputResource result = await streamingJobInput.UpdateAsync(input);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a stream IoT Hub input
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAStreamIoTHubInput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Update_Stream_IoTHub.json
            // this example is just showing the usage of "Inputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobInputResource created on azure
            // for more information of creating StreamingJobInputResource, please refer to the document of StreamingJobInputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3467";
            string jobName = "sj9742";
            string inputName = "input7970";
            ResourceIdentifier streamingJobInputResourceId = StreamingJobInputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, inputName);
            StreamingJobInputResource streamingJobInput = client.GetStreamingJobInputResource(streamingJobInputResourceId);

            // invoke the operation
            StreamingJobInputData input = new StreamingJobInputData()
            {
                Properties = new StreamInputProperties()
                {
                    Datasource = new IoTHubStreamInputDataSource()
                    {
                        Endpoint = "messages/operationsMonitoringEvents",
                    },
                    Serialization = new CsvFormatSerialization()
                    {
                        FieldDelimiter = "|",
                        Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                    },
                },
            };
            StreamingJobInputResource result = await streamingJobInput.UpdateAsync(input);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a stream blob input
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAStreamBlobInput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Update_Stream_Blob.json
            // this example is just showing the usage of "Inputs_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobInputResource created on azure
            // for more information of creating StreamingJobInputResource, please refer to the document of StreamingJobInputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8161";
            string jobName = "sj6695";
            string inputName = "input8899";
            ResourceIdentifier streamingJobInputResourceId = StreamingJobInputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, inputName);
            StreamingJobInputResource streamingJobInput = client.GetStreamingJobInputResource(streamingJobInputResourceId);

            // invoke the operation
            StreamingJobInputData input = new StreamingJobInputData()
            {
                Properties = new StreamInputProperties()
                {
                    Datasource = new BlobStreamInputDataSource()
                    {
                        SourcePartitionCount = 32,
                    },
                    Serialization = new CsvFormatSerialization()
                    {
                        FieldDelimiter = "|",
                        Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                    },
                },
            };
            StreamingJobInputResource result = await streamingJobInput.UpdateAsync(input);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete an input
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAnInput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Delete.json
            // this example is just showing the usage of "Inputs_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobInputResource created on azure
            // for more information of creating StreamingJobInputResource, please refer to the document of StreamingJobInputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8440";
            string jobName = "sj9597";
            string inputName = "input7225";
            ResourceIdentifier streamingJobInputResourceId = StreamingJobInputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, inputName);
            StreamingJobInputResource streamingJobInput = client.GetStreamingJobInputResource(streamingJobInputResourceId);

            // invoke the operation
            await streamingJobInput.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get a reference blob input with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAReferenceBlobInputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Reference_Blob_CSV.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobInputResource created on azure
            // for more information of creating StreamingJobInputResource, please refer to the document of StreamingJobInputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8440";
            string jobName = "sj9597";
            string inputName = "input7225";
            ResourceIdentifier streamingJobInputResourceId = StreamingJobInputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, inputName);
            StreamingJobInputResource streamingJobInput = client.GetStreamingJobInputResource(streamingJobInputResourceId);

            // invoke the operation
            StreamingJobInputResource result = await streamingJobInput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a stream Event Hub input with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAStreamEventHubInputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Stream_EventHub_JSON.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobInputResource created on azure
            // for more information of creating StreamingJobInputResource, please refer to the document of StreamingJobInputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3139";
            string jobName = "sj197";
            string inputName = "input7425";
            ResourceIdentifier streamingJobInputResourceId = StreamingJobInputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, inputName);
            StreamingJobInputResource streamingJobInput = client.GetStreamingJobInputResource(streamingJobInputResourceId);

            // invoke the operation
            StreamingJobInputResource result = await streamingJobInput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a stream IoT Hub input with Avro serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAStreamIoTHubInputWithAvroSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Stream_IoTHub_Avro.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobInputResource created on azure
            // for more information of creating StreamingJobInputResource, please refer to the document of StreamingJobInputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3467";
            string jobName = "sj9742";
            string inputName = "input7970";
            ResourceIdentifier streamingJobInputResourceId = StreamingJobInputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, inputName);
            StreamingJobInputResource streamingJobInput = client.GetStreamingJobInputResource(streamingJobInputResourceId);

            // invoke the operation
            StreamingJobInputResource result = await streamingJobInput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a stream blob input with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAStreamBlobInputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Stream_Blob_CSV.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobInputResource created on azure
            // for more information of creating StreamingJobInputResource, please refer to the document of StreamingJobInputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8161";
            string jobName = "sj6695";
            string inputName = "input8899";
            ResourceIdentifier streamingJobInputResourceId = StreamingJobInputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, inputName);
            StreamingJobInputResource streamingJobInput = client.GetStreamingJobInputResource(streamingJobInputResourceId);

            // invoke the operation
            StreamingJobInputResource result = await streamingJobInput.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Test the connection for an input
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Test_TestTheConnectionForAnInput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Test.json
            // this example is just showing the usage of "Inputs_Test" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobInputResource created on azure
            // for more information of creating StreamingJobInputResource, please refer to the document of StreamingJobInputResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8440";
            string jobName = "sj9597";
            string inputName = "input7225";
            ResourceIdentifier streamingJobInputResourceId = StreamingJobInputResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, inputName);
            StreamingJobInputResource streamingJobInput = client.GetStreamingJobInputResource(streamingJobInputResourceId);

            // invoke the operation
            ArmOperation<StreamAnalyticsResourceTestStatus> lro = await streamingJobInput.TestAsync(WaitUntil.Completed);
            StreamAnalyticsResourceTestStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
