// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.StreamAnalytics.Models;

namespace Azure.ResourceManager.StreamAnalytics.Samples
{
    public partial class Sample_StreamingJobInputCollection
    {
        // Create a Gateway Message Bus input
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAGatewayMessageBusInput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Create_GatewayMessageBus.json
            // this example is just showing the usage of "Inputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3467";
            string jobName = "sj9742";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7970";
            StreamingJobInputData input = new StreamingJobInputData()
            {
                Properties = new StreamInputProperties()
                {
                    Datasource = new GatewayMessageBusStreamInputDataSource()
                    {
                        Topic = "EdgeTopic1",
                    },
                },
            };
            ArmOperation<StreamingJobInputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, inputName, input);
            StreamingJobInputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a reference blob input with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAReferenceBlobInputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Create_Reference_Blob_CSV.json
            // this example is just showing the usage of "Inputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8440";
            string jobName = "sj9597";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7225";
            StreamingJobInputData input = new StreamingJobInputData()
            {
                Properties = new ReferenceInputProperties()
                {
                    Datasource = new BlobReferenceInputDataSource()
                    {
                        StorageAccounts =
{
new StreamAnalyticsStorageAccount()
{
AccountName = "someAccountName",
AccountKey = "someAccountKey==",
}
},
                        Container = "state",
                        PathPattern = "{date}/{time}",
                        DateFormat = "yyyy/MM/dd",
                        TimeFormat = "HH",
                        BlobName = "myblobinput",
                        DeltaPathPattern = "/testBlob/{date}/delta/{time}/",
                        SourcePartitionCount = 16,
                        FullSnapshotRefreshInterval = TimeSpan.Parse("16:14:30"),
                        DeltaSnapshotRefreshInterval = TimeSpan.Parse("16:14:30"),
                    },
                    Serialization = new CsvFormatSerialization()
                    {
                        FieldDelimiter = ",",
                        Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                    },
                },
            };
            ArmOperation<StreamingJobInputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, inputName, input);
            StreamingJobInputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a stream Event Hub input with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAStreamEventHubInputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Create_Stream_EventHub_JSON.json
            // this example is just showing the usage of "Inputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3139";
            string jobName = "sj197";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7425";
            StreamingJobInputData input = new StreamingJobInputData()
            {
                Properties = new StreamInputProperties()
                {
                    Datasource = new EventHubStreamInputDataSource()
                    {
                        ServiceBusNamespace = "sdktest",
                        SharedAccessPolicyName = "RootManageSharedAccessKey",
                        SharedAccessPolicyKey = "someSharedAccessPolicyKey==",
                        EventHubName = "sdkeventhub",
                        ConsumerGroupName = "sdkconsumergroup",
                    },
                    Serialization = new JsonFormatSerialization()
                    {
                        Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                    },
                    WatermarkMode = StreamingJobInputWatermarkMode.ReadWatermark,
                },
            };
            ArmOperation<StreamingJobInputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, inputName, input);
            StreamingJobInputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a stream IoT Hub input with Avro serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAStreamIoTHubInputWithAvroSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Create_Stream_IoTHub_Avro.json
            // this example is just showing the usage of "Inputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3467";
            string jobName = "sj9742";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7970";
            StreamingJobInputData input = new StreamingJobInputData()
            {
                Properties = new StreamInputProperties()
                {
                    Datasource = new IoTHubStreamInputDataSource()
                    {
                        IotHubNamespace = "iothub",
                        SharedAccessPolicyName = "owner",
                        SharedAccessPolicyKey = "sharedAccessPolicyKey=",
                        ConsumerGroupName = "sdkconsumergroup",
                        Endpoint = "messages/events",
                    },
                    Serialization = new AvroFormatSerialization(),
                },
            };
            ArmOperation<StreamingJobInputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, inputName, input);
            StreamingJobInputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a stream blob input with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAStreamBlobInputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Create_Stream_Blob_CSV.json
            // this example is just showing the usage of "Inputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8161";
            string jobName = "sj6695";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input8899";
            StreamingJobInputData input = new StreamingJobInputData()
            {
                Properties = new StreamInputProperties()
                {
                    Datasource = new BlobStreamInputDataSource()
                    {
                        StorageAccounts =
{
new StreamAnalyticsStorageAccount()
{
AccountName = "someAccountName",
AccountKey = "someAccountKey==",
}
},
                        Container = "state",
                        PathPattern = "{date}/{time}",
                        DateFormat = "yyyy/MM/dd",
                        TimeFormat = "HH",
                        SourcePartitionCount = 16,
                    },
                    Serialization = new CsvFormatSerialization()
                    {
                        FieldDelimiter = ",",
                        Encoding = StreamAnalyticsDataSerializationEncoding.Utf8,
                    },
                },
            };
            ArmOperation<StreamingJobInputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, inputName, input);
            StreamingJobInputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create an Event Grid input
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAnEventGridInput()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Create_EventGrid.json
            // this example is just showing the usage of "Inputs_CreateOrReplace" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3467";
            string jobName = "sj9742";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7970";
            StreamingJobInputData input = new StreamingJobInputData()
            {
                Properties = new StreamInputProperties()
                {
                    Datasource = new EventGridStreamInputDataSource()
                    {
                        Subscriber = new EventHubV2StreamInputDataSource()
                        {
                            ServiceBusNamespace = "sdktest",
                            SharedAccessPolicyName = "RootManageSharedAccessKey",
                            SharedAccessPolicyKey = "someSharedAccessPolicyKey==",
                            AuthenticationMode = StreamAnalyticsAuthenticationMode.Msi,
                            EventHubName = "sdkeventhub",
                            PartitionCount = 16,
                            ConsumerGroupName = "sdkconsumergroup",
                        },
                        Schema = EventGridEventSchemaType.CloudEventSchema,
                        StorageAccounts =
{
new StreamAnalyticsStorageAccount()
{
AccountName = "myaccount",
AccountKey = "myaccountkey",
AuthenticationMode = StreamAnalyticsAuthenticationMode.Msi,
}
},
                        EventTypes =
{
"Microsoft.Storage.BlobCreated"
},
                    },
                },
            };
            ArmOperation<StreamingJobInputResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, inputName, input);
            StreamingJobInputResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a reference blob input with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAReferenceBlobInputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Reference_Blob_CSV.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8440";
            string jobName = "sj9597";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7225";
            StreamingJobInputResource result = await collection.GetAsync(inputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a reference blob input with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAReferenceBlobInputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Reference_Blob_CSV.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8440";
            string jobName = "sj9597";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7225";
            bool result = await collection.ExistsAsync(inputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a reference blob input with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAReferenceBlobInputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Reference_Blob_CSV.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8440";
            string jobName = "sj9597";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7225";
            NullableResponse<StreamingJobInputResource> response = await collection.GetIfExistsAsync(inputName);
            StreamingJobInputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobInputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get a stream Event Hub input with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAStreamEventHubInputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Stream_EventHub_JSON.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3139";
            string jobName = "sj197";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7425";
            StreamingJobInputResource result = await collection.GetAsync(inputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a stream Event Hub input with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAStreamEventHubInputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Stream_EventHub_JSON.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3139";
            string jobName = "sj197";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7425";
            bool result = await collection.ExistsAsync(inputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a stream Event Hub input with JSON serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAStreamEventHubInputWithJSONSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Stream_EventHub_JSON.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3139";
            string jobName = "sj197";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7425";
            NullableResponse<StreamingJobInputResource> response = await collection.GetIfExistsAsync(inputName);
            StreamingJobInputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobInputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get a stream IoT Hub input with Avro serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAStreamIoTHubInputWithAvroSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Stream_IoTHub_Avro.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3467";
            string jobName = "sj9742";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7970";
            StreamingJobInputResource result = await collection.GetAsync(inputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a stream IoT Hub input with Avro serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAStreamIoTHubInputWithAvroSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Stream_IoTHub_Avro.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3467";
            string jobName = "sj9742";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7970";
            bool result = await collection.ExistsAsync(inputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a stream IoT Hub input with Avro serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAStreamIoTHubInputWithAvroSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Stream_IoTHub_Avro.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3467";
            string jobName = "sj9742";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input7970";
            NullableResponse<StreamingJobInputResource> response = await collection.GetIfExistsAsync(inputName);
            StreamingJobInputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobInputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get a stream blob input with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAStreamBlobInputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Stream_Blob_CSV.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8161";
            string jobName = "sj6695";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input8899";
            StreamingJobInputResource result = await collection.GetAsync(inputName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingJobInputData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a stream blob input with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAStreamBlobInputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Stream_Blob_CSV.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8161";
            string jobName = "sj6695";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input8899";
            bool result = await collection.ExistsAsync(inputName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a stream blob input with CSV serialization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAStreamBlobInputWithCSVSerialization()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_Get_Stream_Blob_CSV.json
            // this example is just showing the usage of "Inputs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8161";
            string jobName = "sj6695";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation
            string inputName = "input8899";
            NullableResponse<StreamingJobInputResource> response = await collection.GetIfExistsAsync(inputName);
            StreamingJobInputResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobInputData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List all inputs in a streaming job
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListAllInputsInAStreamingJob()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_ListByStreamingJob.json
            // this example is just showing the usage of "Inputs_ListByStreamingJob" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg8440";
            string jobName = "sj9597";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation and iterate over the result
            await foreach (StreamingJobInputResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobInputData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List all inputs in a streaming job and include diagnostic information using the $select OData query parameter
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListAllInputsInAStreamingJobAndIncludeDiagnosticInformationUsingTheSelectODataQueryParameter()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Input_ListByStreamingJob_Diagnostics.json
            // this example is just showing the usage of "Inputs_ListByStreamingJob" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamingJobResource created on azure
            // for more information of creating StreamingJobResource, please refer to the document of StreamingJobResource
            string subscriptionId = "56b5e0a9-b645-407d-99b0-c64f86013e3d";
            string resourceGroupName = "sjrg3276";
            string jobName = "sj7804";
            ResourceIdentifier streamingJobResourceId = StreamingJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            StreamingJobResource streamingJob = client.GetStreamingJobResource(streamingJobResourceId);

            // get the collection of this StreamingJobInputResource
            StreamingJobInputCollection collection = streamingJob.GetStreamingJobInputs();

            // invoke the operation and iterate over the result
            string select = "*";
            await foreach (StreamingJobInputResource item in collection.GetAllAsync(select: select))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingJobInputData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
