// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.StreamAnalytics.Models;

namespace Azure.ResourceManager.StreamAnalytics.Samples
{
    public partial class Sample_StreamAnalyticsPrivateEndpointResource
    {
        // Create a private endpoint
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAPrivateEndpoint()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2020-03-01-preview/examples/PrivateEndpoint_Create.json
            // this example is just showing the usage of "PrivateEndpoints_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamAnalyticsPrivateEndpointResource created on azure
            // for more information of creating StreamAnalyticsPrivateEndpointResource, please refer to the document of StreamAnalyticsPrivateEndpointResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "sjrg";
            string clusterName = "testcluster";
            string privateEndpointName = "testpe";
            ResourceIdentifier streamAnalyticsPrivateEndpointResourceId = StreamAnalyticsPrivateEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, privateEndpointName);
            StreamAnalyticsPrivateEndpointResource streamAnalyticsPrivateEndpoint = client.GetStreamAnalyticsPrivateEndpointResource(streamAnalyticsPrivateEndpointResourceId);

            // invoke the operation
            StreamAnalyticsPrivateEndpointData data = new StreamAnalyticsPrivateEndpointData()
            {
                Properties = new StreamAnalyticsPrivateEndpointProperties()
                {
                    ManualPrivateLinkServiceConnections =
{
new StreamAnalyticsPrivateLinkServiceConnection()
{
PrivateLinkServiceId = new ResourceIdentifier("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
GroupIds =
{
"groupIdFromResource"
},
}
},
                },
            };
            ArmOperation<StreamAnalyticsPrivateEndpointResource> lro = await streamAnalyticsPrivateEndpoint.UpdateAsync(WaitUntil.Completed, data);
            StreamAnalyticsPrivateEndpointResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamAnalyticsPrivateEndpointData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a private endpoint
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAPrivateEndpoint()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2020-03-01-preview/examples/PrivateEndpoint_Get.json
            // this example is just showing the usage of "PrivateEndpoints_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamAnalyticsPrivateEndpointResource created on azure
            // for more information of creating StreamAnalyticsPrivateEndpointResource, please refer to the document of StreamAnalyticsPrivateEndpointResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "sjrg";
            string clusterName = "testcluster";
            string privateEndpointName = "testpe";
            ResourceIdentifier streamAnalyticsPrivateEndpointResourceId = StreamAnalyticsPrivateEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, privateEndpointName);
            StreamAnalyticsPrivateEndpointResource streamAnalyticsPrivateEndpoint = client.GetStreamAnalyticsPrivateEndpointResource(streamAnalyticsPrivateEndpointResourceId);

            // invoke the operation
            StreamAnalyticsPrivateEndpointResource result = await streamAnalyticsPrivateEndpoint.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamAnalyticsPrivateEndpointData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a private endpoint
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAPrivateEndpoint()
        {
            // Generated from example definition: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2020-03-01-preview/examples/PrivateEndpoint_Delete.json
            // this example is just showing the usage of "PrivateEndpoints_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StreamAnalyticsPrivateEndpointResource created on azure
            // for more information of creating StreamAnalyticsPrivateEndpointResource, please refer to the document of StreamAnalyticsPrivateEndpointResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "sjrg";
            string clusterName = "testcluster";
            string privateEndpointName = "testpe";
            ResourceIdentifier streamAnalyticsPrivateEndpointResourceId = StreamAnalyticsPrivateEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, privateEndpointName);
            StreamAnalyticsPrivateEndpointResource streamAnalyticsPrivateEndpoint = client.GetStreamAnalyticsPrivateEndpointResource(streamAnalyticsPrivateEndpointResourceId);

            // invoke the operation
            await streamAnalyticsPrivateEndpoint.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
