// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.StorageSync.Models;

namespace Azure.ResourceManager.StorageSync
{
    /// <summary>
    /// A class representing the StorageSyncWorkflow data model.
    /// Workflow resource.
    /// </summary>
    public partial class StorageSyncWorkflowData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageSyncWorkflowData"/>. </summary>
        public StorageSyncWorkflowData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageSyncWorkflowData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="lastStepName"> last step name. </param>
        /// <param name="status"> workflow status. </param>
        /// <param name="operation"> operation direction. </param>
        /// <param name="steps"> workflow steps. </param>
        /// <param name="lastOperationId"> workflow last operation identifier. </param>
        /// <param name="commandName"> workflow command name. </param>
        /// <param name="createdOn"> workflow created timestamp. </param>
        /// <param name="lastStatusUpdatedOn"> workflow last status timestamp. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageSyncWorkflowData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string lastStepName, StorageSyncWorkflowStatus? status, StorageSyncOperationDirection? operation, string steps, Guid? lastOperationId, string commandName, DateTimeOffset? createdOn, DateTimeOffset? lastStatusUpdatedOn, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            LastStepName = lastStepName;
            Status = status;
            Operation = operation;
            Steps = steps;
            LastOperationId = lastOperationId;
            CommandName = commandName;
            CreatedOn = createdOn;
            LastStatusUpdatedOn = lastStatusUpdatedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> last step name. </summary>
        public string LastStepName { get; set; }
        /// <summary> workflow status. </summary>
        public StorageSyncWorkflowStatus? Status { get; set; }
        /// <summary> operation direction. </summary>
        public StorageSyncOperationDirection? Operation { get; set; }
        /// <summary> workflow steps. </summary>
        public string Steps { get; set; }
        /// <summary> workflow last operation identifier. </summary>
        public Guid? LastOperationId { get; set; }
        /// <summary> workflow command name. </summary>
        public string CommandName { get; }
        /// <summary> workflow created timestamp. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> workflow last status timestamp. </summary>
        public DateTimeOffset? LastStatusUpdatedOn { get; }
    }
}
