// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Type of the Workflow Status. </summary>
    public readonly partial struct StorageSyncWorkflowStatus : IEquatable<StorageSyncWorkflowStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageSyncWorkflowStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageSyncWorkflowStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "active";
        private const string ExpiredValue = "expired";
        private const string SucceededValue = "succeeded";
        private const string AbortedValue = "aborted";
        private const string FailedValue = "failed";

        /// <summary> active. </summary>
        public static StorageSyncWorkflowStatus Active { get; } = new StorageSyncWorkflowStatus(ActiveValue);
        /// <summary> expired. </summary>
        public static StorageSyncWorkflowStatus Expired { get; } = new StorageSyncWorkflowStatus(ExpiredValue);
        /// <summary> succeeded. </summary>
        public static StorageSyncWorkflowStatus Succeeded { get; } = new StorageSyncWorkflowStatus(SucceededValue);
        /// <summary> aborted. </summary>
        public static StorageSyncWorkflowStatus Aborted { get; } = new StorageSyncWorkflowStatus(AbortedValue);
        /// <summary> failed. </summary>
        public static StorageSyncWorkflowStatus Failed { get; } = new StorageSyncWorkflowStatus(FailedValue);
        /// <summary> Determines if two <see cref="StorageSyncWorkflowStatus"/> values are the same. </summary>
        public static bool operator ==(StorageSyncWorkflowStatus left, StorageSyncWorkflowStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageSyncWorkflowStatus"/> values are not the same. </summary>
        public static bool operator !=(StorageSyncWorkflowStatus left, StorageSyncWorkflowStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageSyncWorkflowStatus"/>. </summary>
        public static implicit operator StorageSyncWorkflowStatus(string value) => new StorageSyncWorkflowStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageSyncWorkflowStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageSyncWorkflowStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
