// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Parameters for updating an Server Endpoint. </summary>
    public partial class StorageSyncServerEndpointPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageSyncServerEndpointPatch"/>. </summary>
        public StorageSyncServerEndpointPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageSyncServerEndpointPatch"/>. </summary>
        /// <param name="cloudTiering"> Cloud Tiering. </param>
        /// <param name="volumeFreeSpacePercent"> Level of free space to be maintained by Cloud Tiering if it is enabled. </param>
        /// <param name="tierFilesOlderThanDays"> Tier files older than days. </param>
        /// <param name="offlineDataTransfer"> Offline data transfer. </param>
        /// <param name="offlineDataTransferShareName"> Offline data transfer share name. </param>
        /// <param name="localCacheMode"> Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageSyncServerEndpointPatch(StorageSyncFeatureStatus? cloudTiering, int? volumeFreeSpacePercent, int? tierFilesOlderThanDays, StorageSyncFeatureStatus? offlineDataTransfer, string offlineDataTransferShareName, LocalCacheMode? localCacheMode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CloudTiering = cloudTiering;
            VolumeFreeSpacePercent = volumeFreeSpacePercent;
            TierFilesOlderThanDays = tierFilesOlderThanDays;
            OfflineDataTransfer = offlineDataTransfer;
            OfflineDataTransferShareName = offlineDataTransferShareName;
            LocalCacheMode = localCacheMode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Cloud Tiering. </summary>
        public StorageSyncFeatureStatus? CloudTiering { get; set; }
        /// <summary> Level of free space to be maintained by Cloud Tiering if it is enabled. </summary>
        public int? VolumeFreeSpacePercent { get; set; }
        /// <summary> Tier files older than days. </summary>
        public int? TierFilesOlderThanDays { get; set; }
        /// <summary> Offline data transfer. </summary>
        public StorageSyncFeatureStatus? OfflineDataTransfer { get; set; }
        /// <summary> Offline data transfer share name. </summary>
        public string OfflineDataTransferShareName { get; set; }
        /// <summary> Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access. </summary>
        public LocalCacheMode? LocalCacheMode { get; set; }
    }
}
