// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.StorageSync.Models
{
    public partial class StorageSyncServerEndpointCreateOrUpdateContent : IUtf8JsonSerializable, IJsonModel<StorageSyncServerEndpointCreateOrUpdateContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StorageSyncServerEndpointCreateOrUpdateContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StorageSyncServerEndpointCreateOrUpdateContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageSyncServerEndpointCreateOrUpdateContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageSyncServerEndpointCreateOrUpdateContent)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(ServerLocalPath))
            {
                writer.WritePropertyName("serverLocalPath"u8);
                writer.WriteStringValue(ServerLocalPath);
            }
            if (Optional.IsDefined(CloudTiering))
            {
                writer.WritePropertyName("cloudTiering"u8);
                writer.WriteStringValue(CloudTiering.Value.ToString());
            }
            if (Optional.IsDefined(VolumeFreeSpacePercent))
            {
                writer.WritePropertyName("volumeFreeSpacePercent"u8);
                writer.WriteNumberValue(VolumeFreeSpacePercent.Value);
            }
            if (Optional.IsDefined(TierFilesOlderThanDays))
            {
                writer.WritePropertyName("tierFilesOlderThanDays"u8);
                writer.WriteNumberValue(TierFilesOlderThanDays.Value);
            }
            if (Optional.IsDefined(FriendlyName))
            {
                writer.WritePropertyName("friendlyName"u8);
                writer.WriteStringValue(FriendlyName);
            }
            if (Optional.IsDefined(ServerResourceId))
            {
                writer.WritePropertyName("serverResourceId"u8);
                writer.WriteStringValue(ServerResourceId);
            }
            if (Optional.IsDefined(OfflineDataTransfer))
            {
                writer.WritePropertyName("offlineDataTransfer"u8);
                writer.WriteStringValue(OfflineDataTransfer.Value.ToString());
            }
            if (Optional.IsDefined(OfflineDataTransferShareName))
            {
                writer.WritePropertyName("offlineDataTransferShareName"u8);
                writer.WriteStringValue(OfflineDataTransferShareName);
            }
            if (Optional.IsDefined(InitialDownloadPolicy))
            {
                writer.WritePropertyName("initialDownloadPolicy"u8);
                writer.WriteStringValue(InitialDownloadPolicy.Value.ToString());
            }
            if (Optional.IsDefined(LocalCacheMode))
            {
                writer.WritePropertyName("localCacheMode"u8);
                writer.WriteStringValue(LocalCacheMode.Value.ToString());
            }
            if (Optional.IsDefined(InitialUploadPolicy))
            {
                writer.WritePropertyName("initialUploadPolicy"u8);
                writer.WriteStringValue(InitialUploadPolicy.Value.ToString());
            }
            writer.WriteEndObject();
        }

        StorageSyncServerEndpointCreateOrUpdateContent IJsonModel<StorageSyncServerEndpointCreateOrUpdateContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageSyncServerEndpointCreateOrUpdateContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageSyncServerEndpointCreateOrUpdateContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStorageSyncServerEndpointCreateOrUpdateContent(document.RootElement, options);
        }

        internal static StorageSyncServerEndpointCreateOrUpdateContent DeserializeStorageSyncServerEndpointCreateOrUpdateContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string serverLocalPath = default;
            StorageSyncFeatureStatus? cloudTiering = default;
            int? volumeFreeSpacePercent = default;
            int? tierFilesOlderThanDays = default;
            string friendlyName = default;
            ResourceIdentifier serverResourceId = default;
            StorageSyncFeatureStatus? offlineDataTransfer = default;
            string offlineDataTransferShareName = default;
            InitialDownloadPolicy? initialDownloadPolicy = default;
            LocalCacheMode? localCacheMode = default;
            InitialUploadPolicy? initialUploadPolicy = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("serverLocalPath"u8))
                        {
                            serverLocalPath = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("cloudTiering"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            cloudTiering = new StorageSyncFeatureStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("volumeFreeSpacePercent"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            volumeFreeSpacePercent = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("tierFilesOlderThanDays"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            tierFilesOlderThanDays = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("friendlyName"u8))
                        {
                            friendlyName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("serverResourceId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            serverResourceId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("offlineDataTransfer"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            offlineDataTransfer = new StorageSyncFeatureStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("offlineDataTransferShareName"u8))
                        {
                            offlineDataTransferShareName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("initialDownloadPolicy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            initialDownloadPolicy = new InitialDownloadPolicy(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("localCacheMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            localCacheMode = new LocalCacheMode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("initialUploadPolicy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            initialUploadPolicy = new InitialUploadPolicy(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StorageSyncServerEndpointCreateOrUpdateContent(
                id,
                name,
                type,
                systemData,
                serverLocalPath,
                cloudTiering,
                volumeFreeSpacePercent,
                tierFilesOlderThanDays,
                friendlyName,
                serverResourceId,
                offlineDataTransfer,
                offlineDataTransferShareName,
                initialDownloadPolicy,
                localCacheMode,
                initialUploadPolicy,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StorageSyncServerEndpointCreateOrUpdateContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageSyncServerEndpointCreateOrUpdateContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StorageSyncServerEndpointCreateOrUpdateContent)} does not support writing '{options.Format}' format.");
            }
        }

        StorageSyncServerEndpointCreateOrUpdateContent IPersistableModel<StorageSyncServerEndpointCreateOrUpdateContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageSyncServerEndpointCreateOrUpdateContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStorageSyncServerEndpointCreateOrUpdateContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StorageSyncServerEndpointCreateOrUpdateContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StorageSyncServerEndpointCreateOrUpdateContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
