// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct StorageSyncPrivateEndpointConnectionProvisioningState : IEquatable<StorageSyncPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageSyncPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageSyncPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static StorageSyncPrivateEndpointConnectionProvisioningState Succeeded { get; } = new StorageSyncPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static StorageSyncPrivateEndpointConnectionProvisioningState Creating { get; } = new StorageSyncPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static StorageSyncPrivateEndpointConnectionProvisioningState Deleting { get; } = new StorageSyncPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static StorageSyncPrivateEndpointConnectionProvisioningState Failed { get; } = new StorageSyncPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="StorageSyncPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(StorageSyncPrivateEndpointConnectionProvisioningState left, StorageSyncPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageSyncPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(StorageSyncPrivateEndpointConnectionProvisioningState left, StorageSyncPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageSyncPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator StorageSyncPrivateEndpointConnectionProvisioningState(string value) => new StorageSyncPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageSyncPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageSyncPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
