// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Type of the Operation Direction. </summary>
    public readonly partial struct StorageSyncOperationDirection : IEquatable<StorageSyncOperationDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageSyncOperationDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageSyncOperationDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DoValue = "do";
        private const string UndoValue = "undo";
        private const string CancelValue = "cancel";

        /// <summary> do. </summary>
        public static StorageSyncOperationDirection Do { get; } = new StorageSyncOperationDirection(DoValue);
        /// <summary> undo. </summary>
        public static StorageSyncOperationDirection Undo { get; } = new StorageSyncOperationDirection(UndoValue);
        /// <summary> cancel. </summary>
        public static StorageSyncOperationDirection Cancel { get; } = new StorageSyncOperationDirection(CancelValue);
        /// <summary> Determines if two <see cref="StorageSyncOperationDirection"/> values are the same. </summary>
        public static bool operator ==(StorageSyncOperationDirection left, StorageSyncOperationDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageSyncOperationDirection"/> values are not the same. </summary>
        public static bool operator !=(StorageSyncOperationDirection left, StorageSyncOperationDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageSyncOperationDirection"/>. </summary>
        public static implicit operator StorageSyncOperationDirection(string value) => new StorageSyncOperationDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageSyncOperationDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageSyncOperationDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
