// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.StorageSync.Models
{
    internal static partial class StorageSyncNameUnavailableReasonExtensions
    {
        public static string ToSerialString(this StorageSyncNameUnavailableReason value) => value switch
        {
            StorageSyncNameUnavailableReason.Invalid => "Invalid",
            StorageSyncNameUnavailableReason.AlreadyExists => "AlreadyExists",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StorageSyncNameUnavailableReason value.")
        };

        public static StorageSyncNameUnavailableReason ToStorageSyncNameUnavailableReason(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Invalid")) return StorageSyncNameUnavailableReason.Invalid;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AlreadyExists")) return StorageSyncNameUnavailableReason.AlreadyExists;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StorageSyncNameUnavailableReason value.");
        }
    }
}
