// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Server Endpoint sync status. </summary>
    public partial class ServerEndpointSyncStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServerEndpointSyncStatus"/>. </summary>
        internal ServerEndpointSyncStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ServerEndpointSyncStatus"/>. </summary>
        /// <param name="downloadHealth"> Download Health Status. </param>
        /// <param name="uploadHealth"> Upload Health Status. </param>
        /// <param name="combinedHealth"> Combined Health Status. </param>
        /// <param name="syncActivity"> Sync activity. </param>
        /// <param name="totalPersistentFilesNotSyncingCount"> Total count of persistent files not syncing (combined upload + download). </param>
        /// <param name="lastUpdatedOn"> Last Updated Timestamp. </param>
        /// <param name="uploadStatus"> Upload Status. </param>
        /// <param name="downloadStatus"> Download Status. </param>
        /// <param name="uploadActivity"> Upload sync activity. </param>
        /// <param name="downloadActivity"> Download sync activity. </param>
        /// <param name="offlineDataTransferStatus"> Offline Data Transfer State. </param>
        /// <param name="backgroundDataDownloadActivity"> Background data download activity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServerEndpointSyncStatus(ServerEndpointHealthState? downloadHealth, ServerEndpointHealthState? uploadHealth, ServerEndpointHealthState? combinedHealth, ServerEndpointSyncActivityState? syncActivity, long? totalPersistentFilesNotSyncingCount, DateTimeOffset? lastUpdatedOn, ServerEndpointSyncSessionStatus uploadStatus, ServerEndpointSyncSessionStatus downloadStatus, ServerEndpointSyncActivityStatus uploadActivity, ServerEndpointSyncActivityStatus downloadActivity, ServerEndpointOfflineDataTransferState? offlineDataTransferStatus, ServerEndpointBackgroundDataDownloadActivity backgroundDataDownloadActivity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DownloadHealth = downloadHealth;
            UploadHealth = uploadHealth;
            CombinedHealth = combinedHealth;
            SyncActivity = syncActivity;
            TotalPersistentFilesNotSyncingCount = totalPersistentFilesNotSyncingCount;
            LastUpdatedOn = lastUpdatedOn;
            UploadStatus = uploadStatus;
            DownloadStatus = downloadStatus;
            UploadActivity = uploadActivity;
            DownloadActivity = downloadActivity;
            OfflineDataTransferStatus = offlineDataTransferStatus;
            BackgroundDataDownloadActivity = backgroundDataDownloadActivity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Download Health Status. </summary>
        public ServerEndpointHealthState? DownloadHealth { get; }
        /// <summary> Upload Health Status. </summary>
        public ServerEndpointHealthState? UploadHealth { get; }
        /// <summary> Combined Health Status. </summary>
        public ServerEndpointHealthState? CombinedHealth { get; }
        /// <summary> Sync activity. </summary>
        public ServerEndpointSyncActivityState? SyncActivity { get; }
        /// <summary> Total count of persistent files not syncing (combined upload + download). </summary>
        public long? TotalPersistentFilesNotSyncingCount { get; }
        /// <summary> Last Updated Timestamp. </summary>
        public DateTimeOffset? LastUpdatedOn { get; }
        /// <summary> Upload Status. </summary>
        public ServerEndpointSyncSessionStatus UploadStatus { get; }
        /// <summary> Download Status. </summary>
        public ServerEndpointSyncSessionStatus DownloadStatus { get; }
        /// <summary> Upload sync activity. </summary>
        public ServerEndpointSyncActivityStatus UploadActivity { get; }
        /// <summary> Download sync activity. </summary>
        public ServerEndpointSyncActivityStatus DownloadActivity { get; }
        /// <summary> Offline Data Transfer State. </summary>
        public ServerEndpointOfflineDataTransferState? OfflineDataTransferStatus { get; }
        /// <summary> Background data download activity. </summary>
        public ServerEndpointBackgroundDataDownloadActivity BackgroundDataDownloadActivity { get; }
    }
}
