// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Sync mode for the server endpoint. </summary>
    public readonly partial struct ServerEndpointSyncMode : IEquatable<ServerEndpointSyncMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServerEndpointSyncMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServerEndpointSyncMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RegularValue = "Regular";
        private const string NamespaceDownloadValue = "NamespaceDownload";
        private const string InitialUploadValue = "InitialUpload";
        private const string SnapshotUploadValue = "SnapshotUpload";
        private const string InitialFullDownloadValue = "InitialFullDownload";

        /// <summary> Regular. </summary>
        public static ServerEndpointSyncMode Regular { get; } = new ServerEndpointSyncMode(RegularValue);
        /// <summary> NamespaceDownload. </summary>
        public static ServerEndpointSyncMode NamespaceDownload { get; } = new ServerEndpointSyncMode(NamespaceDownloadValue);
        /// <summary> InitialUpload. </summary>
        public static ServerEndpointSyncMode InitialUpload { get; } = new ServerEndpointSyncMode(InitialUploadValue);
        /// <summary> SnapshotUpload. </summary>
        public static ServerEndpointSyncMode SnapshotUpload { get; } = new ServerEndpointSyncMode(SnapshotUploadValue);
        /// <summary> InitialFullDownload. </summary>
        public static ServerEndpointSyncMode InitialFullDownload { get; } = new ServerEndpointSyncMode(InitialFullDownloadValue);
        /// <summary> Determines if two <see cref="ServerEndpointSyncMode"/> values are the same. </summary>
        public static bool operator ==(ServerEndpointSyncMode left, ServerEndpointSyncMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServerEndpointSyncMode"/> values are not the same. </summary>
        public static bool operator !=(ServerEndpointSyncMode left, ServerEndpointSyncMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServerEndpointSyncMode"/>. </summary>
        public static implicit operator ServerEndpointSyncMode(string value) => new ServerEndpointSyncMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServerEndpointSyncMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServerEndpointSyncMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
