// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Type of the server endpoint health state. </summary>
    public readonly partial struct ServerEndpointHealthState : IEquatable<ServerEndpointHealthState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServerEndpointHealthState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServerEndpointHealthState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnavailableValue = "Unavailable";
        private const string HealthyValue = "Healthy";
        private const string ErrorValue = "Error";

        /// <summary> Unavailable. </summary>
        public static ServerEndpointHealthState Unavailable { get; } = new ServerEndpointHealthState(UnavailableValue);
        /// <summary> Healthy. </summary>
        public static ServerEndpointHealthState Healthy { get; } = new ServerEndpointHealthState(HealthyValue);
        /// <summary> Error. </summary>
        public static ServerEndpointHealthState Error { get; } = new ServerEndpointHealthState(ErrorValue);
        /// <summary> Determines if two <see cref="ServerEndpointHealthState"/> values are the same. </summary>
        public static bool operator ==(ServerEndpointHealthState left, ServerEndpointHealthState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServerEndpointHealthState"/> values are not the same. </summary>
        public static bool operator !=(ServerEndpointHealthState left, ServerEndpointHealthState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServerEndpointHealthState"/>. </summary>
        public static implicit operator ServerEndpointHealthState(string value) => new ServerEndpointHealthState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServerEndpointHealthState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServerEndpointHealthState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
