// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Type of the registered server agent version status. </summary>
    public readonly partial struct RegisteredServerAgentVersionStatus : IEquatable<RegisteredServerAgentVersionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RegisteredServerAgentVersionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RegisteredServerAgentVersionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OkValue = "Ok";
        private const string NearExpiryValue = "NearExpiry";
        private const string ExpiredValue = "Expired";
        private const string BlockedValue = "Blocked";

        /// <summary> Ok. </summary>
        public static RegisteredServerAgentVersionStatus Ok { get; } = new RegisteredServerAgentVersionStatus(OkValue);
        /// <summary> NearExpiry. </summary>
        public static RegisteredServerAgentVersionStatus NearExpiry { get; } = new RegisteredServerAgentVersionStatus(NearExpiryValue);
        /// <summary> Expired. </summary>
        public static RegisteredServerAgentVersionStatus Expired { get; } = new RegisteredServerAgentVersionStatus(ExpiredValue);
        /// <summary> Blocked. </summary>
        public static RegisteredServerAgentVersionStatus Blocked { get; } = new RegisteredServerAgentVersionStatus(BlockedValue);
        /// <summary> Determines if two <see cref="RegisteredServerAgentVersionStatus"/> values are the same. </summary>
        public static bool operator ==(RegisteredServerAgentVersionStatus left, RegisteredServerAgentVersionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RegisteredServerAgentVersionStatus"/> values are not the same. </summary>
        public static bool operator !=(RegisteredServerAgentVersionStatus left, RegisteredServerAgentVersionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RegisteredServerAgentVersionStatus"/>. </summary>
        public static implicit operator RegisteredServerAgentVersionStatus(string value) => new RegisteredServerAgentVersionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RegisteredServerAgentVersionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RegisteredServerAgentVersionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
