// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Policy for how namespace and files are recalled during FastDr. </summary>
    public readonly partial struct InitialDownloadPolicy : IEquatable<InitialDownloadPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InitialDownloadPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InitialDownloadPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NamespaceOnlyValue = "NamespaceOnly";
        private const string NamespaceThenModifiedFilesValue = "NamespaceThenModifiedFiles";
        private const string AvoidTieredFilesValue = "AvoidTieredFiles";

        /// <summary> NamespaceOnly. </summary>
        public static InitialDownloadPolicy NamespaceOnly { get; } = new InitialDownloadPolicy(NamespaceOnlyValue);
        /// <summary> NamespaceThenModifiedFiles. </summary>
        public static InitialDownloadPolicy NamespaceThenModifiedFiles { get; } = new InitialDownloadPolicy(NamespaceThenModifiedFilesValue);
        /// <summary> AvoidTieredFiles. </summary>
        public static InitialDownloadPolicy AvoidTieredFiles { get; } = new InitialDownloadPolicy(AvoidTieredFilesValue);
        /// <summary> Determines if two <see cref="InitialDownloadPolicy"/> values are the same. </summary>
        public static bool operator ==(InitialDownloadPolicy left, InitialDownloadPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InitialDownloadPolicy"/> values are not the same. </summary>
        public static bool operator !=(InitialDownloadPolicy left, InitialDownloadPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InitialDownloadPolicy"/>. </summary>
        public static implicit operator InitialDownloadPolicy(string value) => new InitialDownloadPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InitialDownloadPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InitialDownloadPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
