// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Server endpoint cloud tiering status object. </summary>
    public partial class CloudTieringSpaceSavings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CloudTieringSpaceSavings"/>. </summary>
        internal CloudTieringSpaceSavings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CloudTieringSpaceSavings"/>. </summary>
        /// <param name="lastUpdatedOn"> Last updated timestamp. </param>
        /// <param name="volumeSizeInBytes"> Volume size. </param>
        /// <param name="cloudTotalSizeInBytes"> Total size of content in the azure file share. </param>
        /// <param name="cachedSizeInBytes"> Cached content size on the server. </param>
        /// <param name="spaceSavingsPercent"> Percentage of cached size over total size. </param>
        /// <param name="spaceSavingsInBytes"> Count of bytes saved on the server. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CloudTieringSpaceSavings(DateTimeOffset? lastUpdatedOn, long? volumeSizeInBytes, long? cloudTotalSizeInBytes, long? cachedSizeInBytes, int? spaceSavingsPercent, long? spaceSavingsInBytes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LastUpdatedOn = lastUpdatedOn;
            VolumeSizeInBytes = volumeSizeInBytes;
            CloudTotalSizeInBytes = cloudTotalSizeInBytes;
            CachedSizeInBytes = cachedSizeInBytes;
            SpaceSavingsPercent = spaceSavingsPercent;
            SpaceSavingsInBytes = spaceSavingsInBytes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Last updated timestamp. </summary>
        public DateTimeOffset? LastUpdatedOn { get; }
        /// <summary> Volume size. </summary>
        public long? VolumeSizeInBytes { get; }
        /// <summary> Total size of content in the azure file share. </summary>
        public long? CloudTotalSizeInBytes { get; }
        /// <summary> Cached content size on the server. </summary>
        public long? CachedSizeInBytes { get; }
        /// <summary> Percentage of cached size over total size. </summary>
        public int? SpaceSavingsPercent { get; }
        /// <summary> Count of bytes saved on the server. </summary>
        public long? SpaceSavingsInBytes { get; }
    }
}
