// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Type of the cloud tiering low disk mode state. </summary>
    public readonly partial struct CloudTieringLowDiskModeState : IEquatable<CloudTieringLowDiskModeState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CloudTieringLowDiskModeState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CloudTieringLowDiskModeState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static CloudTieringLowDiskModeState Enabled { get; } = new CloudTieringLowDiskModeState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static CloudTieringLowDiskModeState Disabled { get; } = new CloudTieringLowDiskModeState(DisabledValue);
        /// <summary> Determines if two <see cref="CloudTieringLowDiskModeState"/> values are the same. </summary>
        public static bool operator ==(CloudTieringLowDiskModeState left, CloudTieringLowDiskModeState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CloudTieringLowDiskModeState"/> values are not the same. </summary>
        public static bool operator !=(CloudTieringLowDiskModeState left, CloudTieringLowDiskModeState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CloudTieringLowDiskModeState"/>. </summary>
        public static implicit operator CloudTieringLowDiskModeState(string value) => new CloudTieringLowDiskModeState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CloudTieringLowDiskModeState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CloudTieringLowDiskModeState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
