// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> State of change enumeration activity. </summary>
    public readonly partial struct CloudEndpointChangeEnumerationActivityState : IEquatable<CloudEndpointChangeEnumerationActivityState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CloudEndpointChangeEnumerationActivityState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CloudEndpointChangeEnumerationActivityState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InitialEnumerationInProgressValue = "InitialEnumerationInProgress";
        private const string EnumerationInProgressValue = "EnumerationInProgress";

        /// <summary> InitialEnumerationInProgress. </summary>
        public static CloudEndpointChangeEnumerationActivityState InitialEnumerationInProgress { get; } = new CloudEndpointChangeEnumerationActivityState(InitialEnumerationInProgressValue);
        /// <summary> EnumerationInProgress. </summary>
        public static CloudEndpointChangeEnumerationActivityState EnumerationInProgress { get; } = new CloudEndpointChangeEnumerationActivityState(EnumerationInProgressValue);
        /// <summary> Determines if two <see cref="CloudEndpointChangeEnumerationActivityState"/> values are the same. </summary>
        public static bool operator ==(CloudEndpointChangeEnumerationActivityState left, CloudEndpointChangeEnumerationActivityState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CloudEndpointChangeEnumerationActivityState"/> values are not the same. </summary>
        public static bool operator !=(CloudEndpointChangeEnumerationActivityState left, CloudEndpointChangeEnumerationActivityState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CloudEndpointChangeEnumerationActivityState"/>. </summary>
        public static implicit operator CloudEndpointChangeEnumerationActivityState(string value) => new CloudEndpointChangeEnumerationActivityState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CloudEndpointChangeEnumerationActivityState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CloudEndpointChangeEnumerationActivityState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
