// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Cloud endpoint AFS file share metadata signing certificate public keys. </summary>
    public partial class CloudEndpointAfsShareMetadataCertificatePublicKeys
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CloudEndpointAfsShareMetadataCertificatePublicKeys"/>. </summary>
        internal CloudEndpointAfsShareMetadataCertificatePublicKeys()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CloudEndpointAfsShareMetadataCertificatePublicKeys"/>. </summary>
        /// <param name="firstKey"> The first public key. </param>
        /// <param name="secondKey"> The second public key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CloudEndpointAfsShareMetadataCertificatePublicKeys(string firstKey, string secondKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FirstKey = firstKey;
            SecondKey = secondKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The first public key. </summary>
        public string FirstKey { get; }
        /// <summary> The second public key. </summary>
        public string SecondKey { get; }
    }
}
