// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Change Detection Mode. Applies to a directory specified in directoryPath parameter. </summary>
    public readonly partial struct ChangeDetectionMode : IEquatable<ChangeDetectionMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ChangeDetectionMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ChangeDetectionMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string RecursiveValue = "Recursive";

        /// <summary> Default. </summary>
        public static ChangeDetectionMode Default { get; } = new ChangeDetectionMode(DefaultValue);
        /// <summary> Recursive. </summary>
        public static ChangeDetectionMode Recursive { get; } = new ChangeDetectionMode(RecursiveValue);
        /// <summary> Determines if two <see cref="ChangeDetectionMode"/> values are the same. </summary>
        public static bool operator ==(ChangeDetectionMode left, ChangeDetectionMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ChangeDetectionMode"/> values are not the same. </summary>
        public static bool operator !=(ChangeDetectionMode left, ChangeDetectionMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ChangeDetectionMode"/>. </summary>
        public static implicit operator ChangeDetectionMode(string value) => new ChangeDetectionMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ChangeDetectionMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ChangeDetectionMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
