// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.StorageSync
{
    internal class StorageSyncRegisteredServerOperationSource : IOperationSource<StorageSyncRegisteredServerResource>
    {
        private readonly ArmClient _client;

        internal StorageSyncRegisteredServerOperationSource(ArmClient client)
        {
            _client = client;
        }

        StorageSyncRegisteredServerResource IOperationSource<StorageSyncRegisteredServerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = StorageSyncRegisteredServerData.DeserializeStorageSyncRegisteredServerData(document.RootElement);
            return new StorageSyncRegisteredServerResource(_client, data);
        }

        async ValueTask<StorageSyncRegisteredServerResource> IOperationSource<StorageSyncRegisteredServerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = StorageSyncRegisteredServerData.DeserializeStorageSyncRegisteredServerData(document.RootElement);
            return new StorageSyncRegisteredServerResource(_client, data);
        }
    }
}
