// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.StorageSync.Models;

namespace Azure.ResourceManager.StorageSync
{
    /// <summary>
    /// A class representing the CloudEndpoint data model.
    /// Cloud Endpoint object.
    /// </summary>
    public partial class CloudEndpointData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CloudEndpointData"/>. </summary>
        public CloudEndpointData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CloudEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="storageAccountResourceId"> Storage Account Resource Id. </param>
        /// <param name="azureFileShareName"> Azure file share name. </param>
        /// <param name="storageAccountTenantId"> Storage Account Tenant Id. </param>
        /// <param name="partnershipId"> Partnership Id. </param>
        /// <param name="friendlyName"> Friendly Name. </param>
        /// <param name="isBackupEnabled"> Backup Enabled. </param>
        /// <param name="provisioningState"> CloudEndpoint Provisioning State. </param>
        /// <param name="lastWorkflowId"> CloudEndpoint lastWorkflowId. </param>
        /// <param name="lastOperationName"> Resource Last Operation Name. </param>
        /// <param name="changeEnumerationStatus"> Cloud endpoint change enumeration status. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CloudEndpointData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ResourceIdentifier storageAccountResourceId, string azureFileShareName, Guid? storageAccountTenantId, string partnershipId, string friendlyName, string isBackupEnabled, string provisioningState, string lastWorkflowId, string lastOperationName, CloudEndpointChangeEnumerationStatus changeEnumerationStatus, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            StorageAccountResourceId = storageAccountResourceId;
            AzureFileShareName = azureFileShareName;
            StorageAccountTenantId = storageAccountTenantId;
            PartnershipId = partnershipId;
            FriendlyName = friendlyName;
            IsBackupEnabled = isBackupEnabled;
            ProvisioningState = provisioningState;
            LastWorkflowId = lastWorkflowId;
            LastOperationName = lastOperationName;
            ChangeEnumerationStatus = changeEnumerationStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Storage Account Resource Id. </summary>
        public ResourceIdentifier StorageAccountResourceId { get; set; }
        /// <summary> Azure file share name. </summary>
        public string AzureFileShareName { get; set; }
        /// <summary> Storage Account Tenant Id. </summary>
        public Guid? StorageAccountTenantId { get; set; }
        /// <summary> Partnership Id. </summary>
        public string PartnershipId { get; set; }
        /// <summary> Friendly Name. </summary>
        public string FriendlyName { get; set; }
        /// <summary> Backup Enabled. </summary>
        public string IsBackupEnabled { get; }
        /// <summary> CloudEndpoint Provisioning State. </summary>
        public string ProvisioningState { get; set; }
        /// <summary> CloudEndpoint lastWorkflowId. </summary>
        public string LastWorkflowId { get; set; }
        /// <summary> Resource Last Operation Name. </summary>
        public string LastOperationName { get; set; }
        /// <summary> Cloud endpoint change enumeration status. </summary>
        public CloudEndpointChangeEnumerationStatus ChangeEnumerationStatus { get; }
    }
}
