// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.StorageSync.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmStorageSyncModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.StorageSyncNameAvailabilityContent"/>. </summary>
        /// <param name="name"> The name to check for availability. </param>
        /// <param name="resourceType"> The resource type. Must be set to Microsoft.StorageSync/storageSyncServices. </param>
        /// <returns> A new <see cref="Models.StorageSyncNameAvailabilityContent"/> instance for mocking. </returns>
        public static StorageSyncNameAvailabilityContent StorageSyncNameAvailabilityContent(string name = null, StorageSyncResourceType resourceType = default)
        {
            return new StorageSyncNameAvailabilityContent(name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageSyncNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available. If false, the name has already been taken or invalid and cannot be used. </param>
        /// <param name="reason"> Gets the reason that a Storage Sync Service name could not be used. The Reason element is only returned if NameAvailable is false. </param>
        /// <param name="message"> Gets an error message explaining the Reason value in more detail. </param>
        /// <returns> A new <see cref="Models.StorageSyncNameAvailabilityResult"/> instance for mocking. </returns>
        public static StorageSyncNameAvailabilityResult StorageSyncNameAvailabilityResult(bool? isNameAvailable = null, StorageSyncNameUnavailableReason? reason = null, string message = null)
        {
            return new StorageSyncNameAvailabilityResult(isNameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageSyncServiceCreateOrUpdateContent"/>. </summary>
        /// <param name="location"> Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed. </param>
        /// <param name="tags"> Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters. </param>
        /// <param name="incomingTrafficPolicy"> Incoming Traffic Policy. </param>
        /// <returns> A new <see cref="Models.StorageSyncServiceCreateOrUpdateContent"/> instance for mocking. </returns>
        public static StorageSyncServiceCreateOrUpdateContent StorageSyncServiceCreateOrUpdateContent(AzureLocation location = default, IDictionary<string, string> tags = null, IncomingTrafficPolicy? incomingTrafficPolicy = null)
        {
            tags ??= new Dictionary<string, string>();

            return new StorageSyncServiceCreateOrUpdateContent(location, tags, incomingTrafficPolicy, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StorageSync.StorageSyncServiceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="incomingTrafficPolicy"> Incoming Traffic Policy. </param>
        /// <param name="storageSyncServiceStatus"> Storage Sync service status. </param>
        /// <param name="storageSyncServiceUid"> Storage Sync service Uid. </param>
        /// <param name="provisioningState"> StorageSyncService Provisioning State. </param>
        /// <param name="lastWorkflowId"> StorageSyncService lastWorkflowId. </param>
        /// <param name="lastOperationName"> Resource Last Operation Name. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connection associated with the specified storage sync service. </param>
        /// <returns> A new <see cref="StorageSync.StorageSyncServiceData"/> instance for mocking. </returns>
        public static StorageSyncServiceData StorageSyncServiceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IncomingTrafficPolicy? incomingTrafficPolicy = null, int? storageSyncServiceStatus = null, Guid? storageSyncServiceUid = null, string provisioningState = null, string lastWorkflowId = null, string lastOperationName = null, IEnumerable<StorageSyncPrivateEndpointConnectionData> privateEndpointConnections = null)
        {
            tags ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<StorageSyncPrivateEndpointConnectionData>();

            return new StorageSyncServiceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                incomingTrafficPolicy,
                storageSyncServiceStatus,
                storageSyncServiceUid,
                provisioningState,
                lastWorkflowId,
                lastOperationName,
                privateEndpointConnections?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StorageSync.StorageSyncPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateEndpointId"> The resource of private end point. </param>
        /// <param name="connectionState"> A collection of information about the state of the connection between service consumer and provider. </param>
        /// <param name="provisioningState"> The provisioning state of the private endpoint connection resource. </param>
        /// <returns> A new <see cref="StorageSync.StorageSyncPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static StorageSyncPrivateEndpointConnectionData StorageSyncPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier privateEndpointId = null, StorageSyncPrivateLinkServiceConnectionState connectionState = null, StorageSyncPrivateEndpointConnectionProvisioningState? provisioningState = null)
        {
            return new StorageSyncPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null,
                connectionState,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageSyncPrivateLinkResource"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource Private link DNS zone name. </param>
        /// <returns> A new <see cref="Models.StorageSyncPrivateLinkResource"/> instance for mocking. </returns>
        public static StorageSyncPrivateLinkResource StorageSyncPrivateLinkResource(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new StorageSyncPrivateLinkResource(
                id,
                name,
                resourceType,
                systemData,
                groupId,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StorageSync.StorageSyncGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="uniqueId"> Unique Id. </param>
        /// <param name="syncGroupStatus"> Sync group status. </param>
        /// <returns> A new <see cref="StorageSync.StorageSyncGroupData"/> instance for mocking. </returns>
        public static StorageSyncGroupData StorageSyncGroupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? uniqueId = null, string syncGroupStatus = null)
        {
            return new StorageSyncGroupData(
                id,
                name,
                resourceType,
                systemData,
                uniqueId,
                syncGroupStatus,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageSyncGroupCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The parameters used to create the sync group. </param>
        /// <returns> A new <see cref="Models.StorageSyncGroupCreateOrUpdateContent"/> instance for mocking. </returns>
        public static StorageSyncGroupCreateOrUpdateContent StorageSyncGroupCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, BinaryData properties = null)
        {
            return new StorageSyncGroupCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudEndpointCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="storageAccountResourceId"> Storage Account Resource Id. </param>
        /// <param name="azureFileShareName"> Azure file share name. </param>
        /// <param name="storageAccountTenantId"> Storage Account Tenant Id. </param>
        /// <param name="friendlyName"> Friendly Name. </param>
        /// <returns> A new <see cref="Models.CloudEndpointCreateOrUpdateContent"/> instance for mocking. </returns>
        public static CloudEndpointCreateOrUpdateContent CloudEndpointCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier storageAccountResourceId = null, string azureFileShareName = null, Guid? storageAccountTenantId = null, string friendlyName = null)
        {
            return new CloudEndpointCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                storageAccountResourceId,
                azureFileShareName,
                storageAccountTenantId,
                friendlyName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StorageSync.CloudEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="storageAccountResourceId"> Storage Account Resource Id. </param>
        /// <param name="azureFileShareName"> Azure file share name. </param>
        /// <param name="storageAccountTenantId"> Storage Account Tenant Id. </param>
        /// <param name="partnershipId"> Partnership Id. </param>
        /// <param name="friendlyName"> Friendly Name. </param>
        /// <param name="isBackupEnabled"> Backup Enabled. </param>
        /// <param name="provisioningState"> CloudEndpoint Provisioning State. </param>
        /// <param name="lastWorkflowId"> CloudEndpoint lastWorkflowId. </param>
        /// <param name="lastOperationName"> Resource Last Operation Name. </param>
        /// <param name="changeEnumerationStatus"> Cloud endpoint change enumeration status. </param>
        /// <returns> A new <see cref="StorageSync.CloudEndpointData"/> instance for mocking. </returns>
        public static CloudEndpointData CloudEndpointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier storageAccountResourceId = null, string azureFileShareName = null, Guid? storageAccountTenantId = null, string partnershipId = null, string friendlyName = null, string isBackupEnabled = null, string provisioningState = null, string lastWorkflowId = null, string lastOperationName = null, CloudEndpointChangeEnumerationStatus changeEnumerationStatus = null)
        {
            return new CloudEndpointData(
                id,
                name,
                resourceType,
                systemData,
                storageAccountResourceId,
                azureFileShareName,
                storageAccountTenantId,
                partnershipId,
                friendlyName,
                isBackupEnabled,
                provisioningState,
                lastWorkflowId,
                lastOperationName,
                changeEnumerationStatus,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudEndpointChangeEnumerationStatus"/>. </summary>
        /// <param name="lastUpdatedOn"> Last updated timestamp. </param>
        /// <param name="lastEnumerationStatus"> Status of last completed change enumeration. </param>
        /// <param name="activity"> Change enumeration activity. </param>
        /// <returns> A new <see cref="Models.CloudEndpointChangeEnumerationStatus"/> instance for mocking. </returns>
        public static CloudEndpointChangeEnumerationStatus CloudEndpointChangeEnumerationStatus(DateTimeOffset? lastUpdatedOn = null, CloudEndpointLastChangeEnumerationStatus lastEnumerationStatus = null, CloudEndpointChangeEnumerationActivity activity = null)
        {
            return new CloudEndpointChangeEnumerationStatus(lastUpdatedOn, lastEnumerationStatus, activity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudEndpointLastChangeEnumerationStatus"/>. </summary>
        /// <param name="startedOn"> Timestamp when change enumeration started. </param>
        /// <param name="completedOn"> Timestamp when change enumeration completed. </param>
        /// <param name="namespaceFilesCount"> Count of files in the namespace. </param>
        /// <param name="namespaceDirectoriesCount"> Count of directories in the namespace. </param>
        /// <param name="namespaceSizeInBytes"> Namespace size in bytes. </param>
        /// <param name="nextRunTimestamp"> Timestamp of when change enumeration is expected to run again. </param>
        /// <returns> A new <see cref="Models.CloudEndpointLastChangeEnumerationStatus"/> instance for mocking. </returns>
        public static CloudEndpointLastChangeEnumerationStatus CloudEndpointLastChangeEnumerationStatus(DateTimeOffset? startedOn = null, DateTimeOffset? completedOn = null, long? namespaceFilesCount = null, long? namespaceDirectoriesCount = null, long? namespaceSizeInBytes = null, DateTimeOffset? nextRunTimestamp = null)
        {
            return new CloudEndpointLastChangeEnumerationStatus(
                startedOn,
                completedOn,
                namespaceFilesCount,
                namespaceDirectoriesCount,
                namespaceSizeInBytes,
                nextRunTimestamp,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudEndpointChangeEnumerationActivity"/>. </summary>
        /// <param name="lastUpdatedOn"> Last updated timestamp. </param>
        /// <param name="operationState"> Change enumeration operation state. </param>
        /// <param name="statusCode"> When non-zero, indicates an issue that is delaying change enumeration. </param>
        /// <param name="startedOn"> Timestamp when change enumeration started. </param>
        /// <param name="processedFilesCount"> Count of files processed. </param>
        /// <param name="processedDirectoriesCount"> Count of directories processed. </param>
        /// <param name="totalFilesCount"> Total count of files enumerated. </param>
        /// <param name="totalDirectoriesCount"> Total count of directories enumerated. </param>
        /// <param name="totalSizeInBytes"> Total enumerated size in bytes. </param>
        /// <param name="progressPercent"> Progress percentage for change enumeration run, excluding processing of deletes. </param>
        /// <param name="minutesRemaining"> Estimate of time remaining for the enumeration run. </param>
        /// <param name="totalCountsState"> Change enumeration total counts state. </param>
        /// <param name="deletesProgressPercent"> Progress percentage for processing deletes. This is done separately from the rest of the enumeration run. </param>
        /// <returns> A new <see cref="Models.CloudEndpointChangeEnumerationActivity"/> instance for mocking. </returns>
        public static CloudEndpointChangeEnumerationActivity CloudEndpointChangeEnumerationActivity(DateTimeOffset? lastUpdatedOn = null, CloudEndpointChangeEnumerationActivityState? operationState = null, int? statusCode = null, DateTimeOffset? startedOn = null, long? processedFilesCount = null, long? processedDirectoriesCount = null, long? totalFilesCount = null, long? totalDirectoriesCount = null, long? totalSizeInBytes = null, int? progressPercent = null, int? minutesRemaining = null, CloudEndpointChangeEnumerationTotalCountsState? totalCountsState = null, int? deletesProgressPercent = null)
        {
            return new CloudEndpointChangeEnumerationActivity(
                lastUpdatedOn,
                operationState,
                statusCode,
                startedOn,
                processedFilesCount,
                processedDirectoriesCount,
                totalFilesCount,
                totalDirectoriesCount,
                totalSizeInBytes,
                progressPercent,
                minutesRemaining,
                totalCountsState,
                deletesProgressPercent,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudEndpointPostBackupResult"/>. </summary>
        /// <param name="cloudEndpointName"> cloud endpoint Name. </param>
        /// <returns> A new <see cref="Models.CloudEndpointPostBackupResult"/> instance for mocking. </returns>
        public static CloudEndpointPostBackupResult CloudEndpointPostBackupResult(string cloudEndpointName = null)
        {
            return new CloudEndpointPostBackupResult(cloudEndpointName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudEndpointAfsShareMetadataCertificatePublicKeys"/>. </summary>
        /// <param name="firstKey"> The first public key. </param>
        /// <param name="secondKey"> The second public key. </param>
        /// <returns> A new <see cref="Models.CloudEndpointAfsShareMetadataCertificatePublicKeys"/> instance for mocking. </returns>
        public static CloudEndpointAfsShareMetadataCertificatePublicKeys CloudEndpointAfsShareMetadataCertificatePublicKeys(string firstKey = null, string secondKey = null)
        {
            return new CloudEndpointAfsShareMetadataCertificatePublicKeys(firstKey, secondKey, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageSyncServerEndpointCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="serverLocalPath"> Server Local path. </param>
        /// <param name="cloudTiering"> Cloud Tiering. </param>
        /// <param name="volumeFreeSpacePercent"> Level of free space to be maintained by Cloud Tiering if it is enabled. </param>
        /// <param name="tierFilesOlderThanDays"> Tier files older than days. </param>
        /// <param name="friendlyName"> Friendly Name. </param>
        /// <param name="serverResourceId"> Server Resource Id. </param>
        /// <param name="offlineDataTransfer"> Offline data transfer. </param>
        /// <param name="offlineDataTransferShareName"> Offline data transfer share name. </param>
        /// <param name="initialDownloadPolicy"> Policy for how namespace and files are recalled during FastDr. </param>
        /// <param name="localCacheMode"> Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access. </param>
        /// <param name="initialUploadPolicy"> Policy for how the initial upload sync session is performed. </param>
        /// <returns> A new <see cref="Models.StorageSyncServerEndpointCreateOrUpdateContent"/> instance for mocking. </returns>
        public static StorageSyncServerEndpointCreateOrUpdateContent StorageSyncServerEndpointCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string serverLocalPath = null, StorageSyncFeatureStatus? cloudTiering = null, int? volumeFreeSpacePercent = null, int? tierFilesOlderThanDays = null, string friendlyName = null, ResourceIdentifier serverResourceId = null, StorageSyncFeatureStatus? offlineDataTransfer = null, string offlineDataTransferShareName = null, InitialDownloadPolicy? initialDownloadPolicy = null, LocalCacheMode? localCacheMode = null, InitialUploadPolicy? initialUploadPolicy = null)
        {
            return new StorageSyncServerEndpointCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                serverLocalPath,
                cloudTiering,
                volumeFreeSpacePercent,
                tierFilesOlderThanDays,
                friendlyName,
                serverResourceId,
                offlineDataTransfer,
                offlineDataTransferShareName,
                initialDownloadPolicy,
                localCacheMode,
                initialUploadPolicy,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StorageSync.StorageSyncServerEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="serverLocalPath"> Server Local path. </param>
        /// <param name="cloudTiering"> Cloud Tiering. </param>
        /// <param name="volumeFreeSpacePercent"> Level of free space to be maintained by Cloud Tiering if it is enabled. </param>
        /// <param name="tierFilesOlderThanDays"> Tier files older than days. </param>
        /// <param name="friendlyName"> Friendly Name. </param>
        /// <param name="serverResourceId"> Server Resource Id. </param>
        /// <param name="provisioningState"> ServerEndpoint Provisioning State. </param>
        /// <param name="lastWorkflowId"> ServerEndpoint lastWorkflowId. </param>
        /// <param name="lastOperationName"> Resource Last Operation Name. </param>
        /// <param name="syncStatus"> Server Endpoint sync status. </param>
        /// <param name="offlineDataTransfer"> Offline data transfer. </param>
        /// <param name="offlineDataTransferStorageAccountResourceId"> Offline data transfer storage account resource ID. </param>
        /// <param name="offlineDataTransferStorageAccountTenantId"> Offline data transfer storage account tenant ID. </param>
        /// <param name="offlineDataTransferShareName"> Offline data transfer share name. </param>
        /// <param name="cloudTieringStatus"> Cloud tiering status. Only populated if cloud tiering is enabled. </param>
        /// <param name="recallStatus"> Recall status. Only populated if cloud tiering is enabled. </param>
        /// <param name="initialDownloadPolicy"> Policy for how namespace and files are recalled during FastDr. </param>
        /// <param name="localCacheMode"> Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access. </param>
        /// <param name="initialUploadPolicy"> Policy for how the initial upload sync session is performed. </param>
        /// <param name="serverName"> Server name. </param>
        /// <returns> A new <see cref="StorageSync.StorageSyncServerEndpointData"/> instance for mocking. </returns>
        public static StorageSyncServerEndpointData StorageSyncServerEndpointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string serverLocalPath = null, StorageSyncFeatureStatus? cloudTiering = null, int? volumeFreeSpacePercent = null, int? tierFilesOlderThanDays = null, string friendlyName = null, ResourceIdentifier serverResourceId = null, string provisioningState = null, string lastWorkflowId = null, string lastOperationName = null, ServerEndpointSyncStatus syncStatus = null, StorageSyncFeatureStatus? offlineDataTransfer = null, ResourceIdentifier offlineDataTransferStorageAccountResourceId = null, Guid? offlineDataTransferStorageAccountTenantId = null, string offlineDataTransferShareName = null, ServerEndpointCloudTieringStatus cloudTieringStatus = null, ServerEndpointRecallStatus recallStatus = null, InitialDownloadPolicy? initialDownloadPolicy = null, LocalCacheMode? localCacheMode = null, InitialUploadPolicy? initialUploadPolicy = null, string serverName = null)
        {
            return new StorageSyncServerEndpointData(
                id,
                name,
                resourceType,
                systemData,
                serverLocalPath,
                cloudTiering,
                volumeFreeSpacePercent,
                tierFilesOlderThanDays,
                friendlyName,
                serverResourceId,
                provisioningState,
                lastWorkflowId,
                lastOperationName,
                syncStatus,
                offlineDataTransfer,
                offlineDataTransferStorageAccountResourceId,
                offlineDataTransferStorageAccountTenantId,
                offlineDataTransferShareName,
                cloudTieringStatus,
                recallStatus,
                initialDownloadPolicy,
                localCacheMode,
                initialUploadPolicy,
                serverName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerEndpointSyncStatus"/>. </summary>
        /// <param name="downloadHealth"> Download Health Status. </param>
        /// <param name="uploadHealth"> Upload Health Status. </param>
        /// <param name="combinedHealth"> Combined Health Status. </param>
        /// <param name="syncActivity"> Sync activity. </param>
        /// <param name="totalPersistentFilesNotSyncingCount"> Total count of persistent files not syncing (combined upload + download). </param>
        /// <param name="lastUpdatedOn"> Last Updated Timestamp. </param>
        /// <param name="uploadStatus"> Upload Status. </param>
        /// <param name="downloadStatus"> Download Status. </param>
        /// <param name="uploadActivity"> Upload sync activity. </param>
        /// <param name="downloadActivity"> Download sync activity. </param>
        /// <param name="offlineDataTransferStatus"> Offline Data Transfer State. </param>
        /// <param name="backgroundDataDownloadActivity"> Background data download activity. </param>
        /// <returns> A new <see cref="Models.ServerEndpointSyncStatus"/> instance for mocking. </returns>
        public static ServerEndpointSyncStatus ServerEndpointSyncStatus(ServerEndpointHealthState? downloadHealth = null, ServerEndpointHealthState? uploadHealth = null, ServerEndpointHealthState? combinedHealth = null, ServerEndpointSyncActivityState? syncActivity = null, long? totalPersistentFilesNotSyncingCount = null, DateTimeOffset? lastUpdatedOn = null, ServerEndpointSyncSessionStatus uploadStatus = null, ServerEndpointSyncSessionStatus downloadStatus = null, ServerEndpointSyncActivityStatus uploadActivity = null, ServerEndpointSyncActivityStatus downloadActivity = null, ServerEndpointOfflineDataTransferState? offlineDataTransferStatus = null, ServerEndpointBackgroundDataDownloadActivity backgroundDataDownloadActivity = null)
        {
            return new ServerEndpointSyncStatus(
                downloadHealth,
                uploadHealth,
                combinedHealth,
                syncActivity,
                totalPersistentFilesNotSyncingCount,
                lastUpdatedOn,
                uploadStatus,
                downloadStatus,
                uploadActivity,
                downloadActivity,
                offlineDataTransferStatus,
                backgroundDataDownloadActivity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerEndpointSyncSessionStatus"/>. </summary>
        /// <param name="lastSyncResult"> Last sync result (HResult). </param>
        /// <param name="lastSyncTimestamp"> Last sync timestamp. </param>
        /// <param name="lastSyncSuccessTimestamp"> Last sync success timestamp. </param>
        /// <param name="lastSyncPerItemErrorCount"> Last sync per item error count. </param>
        /// <param name="persistentFilesNotSyncingCount"> Count of persistent files not syncing. </param>
        /// <param name="transientFilesNotSyncingCount"> Count of transient files not syncing. </param>
        /// <param name="filesNotSyncingErrors"> Array of per-item errors coming from the last sync session. </param>
        /// <param name="lastSyncMode"> Sync mode. </param>
        /// <returns> A new <see cref="Models.ServerEndpointSyncSessionStatus"/> instance for mocking. </returns>
        public static ServerEndpointSyncSessionStatus ServerEndpointSyncSessionStatus(int? lastSyncResult = null, DateTimeOffset? lastSyncTimestamp = null, DateTimeOffset? lastSyncSuccessTimestamp = null, long? lastSyncPerItemErrorCount = null, long? persistentFilesNotSyncingCount = null, long? transientFilesNotSyncingCount = null, IEnumerable<ServerEndpointFilesNotSyncingError> filesNotSyncingErrors = null, ServerEndpointSyncMode? lastSyncMode = null)
        {
            filesNotSyncingErrors ??= new List<ServerEndpointFilesNotSyncingError>();

            return new ServerEndpointSyncSessionStatus(
                lastSyncResult,
                lastSyncTimestamp,
                lastSyncSuccessTimestamp,
                lastSyncPerItemErrorCount,
                persistentFilesNotSyncingCount,
                transientFilesNotSyncingCount,
                filesNotSyncingErrors?.ToList(),
                lastSyncMode,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerEndpointFilesNotSyncingError"/>. </summary>
        /// <param name="errorCode"> Error code (HResult). </param>
        /// <param name="persistentCount"> Count of persistent files not syncing with the specified error code. </param>
        /// <param name="transientCount"> Count of transient files not syncing with the specified error code. </param>
        /// <returns> A new <see cref="Models.ServerEndpointFilesNotSyncingError"/> instance for mocking. </returns>
        public static ServerEndpointFilesNotSyncingError ServerEndpointFilesNotSyncingError(int? errorCode = null, long? persistentCount = null, long? transientCount = null)
        {
            return new ServerEndpointFilesNotSyncingError(errorCode, persistentCount, transientCount, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerEndpointSyncActivityStatus"/>. </summary>
        /// <param name="timestamp"> Timestamp when properties were updated. </param>
        /// <param name="perItemErrorCount"> Per item error count. </param>
        /// <param name="appliedItemCount"> Applied item count. </param>
        /// <param name="totalItemCount"> Total item count (if available). </param>
        /// <param name="appliedBytes"> Applied bytes. </param>
        /// <param name="totalBytes"> Total bytes (if available). </param>
        /// <param name="syncMode"> Sync mode. </param>
        /// <param name="sessionMinutesRemaining"> Session minutes remaining (if available). </param>
        /// <returns> A new <see cref="Models.ServerEndpointSyncActivityStatus"/> instance for mocking. </returns>
        public static ServerEndpointSyncActivityStatus ServerEndpointSyncActivityStatus(DateTimeOffset? timestamp = null, long? perItemErrorCount = null, long? appliedItemCount = null, long? totalItemCount = null, long? appliedBytes = null, long? totalBytes = null, ServerEndpointSyncMode? syncMode = null, int? sessionMinutesRemaining = null)
        {
            return new ServerEndpointSyncActivityStatus(
                timestamp,
                perItemErrorCount,
                appliedItemCount,
                totalItemCount,
                appliedBytes,
                totalBytes,
                syncMode,
                sessionMinutesRemaining,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerEndpointBackgroundDataDownloadActivity"/>. </summary>
        /// <param name="timestamp"> Timestamp when properties were updated. </param>
        /// <param name="startedOn"> Timestamp when the operation started. </param>
        /// <param name="percentProgress"> Progress percentage. </param>
        /// <param name="downloadedBytes"> Running count of bytes downloaded. </param>
        /// <returns> A new <see cref="Models.ServerEndpointBackgroundDataDownloadActivity"/> instance for mocking. </returns>
        public static ServerEndpointBackgroundDataDownloadActivity ServerEndpointBackgroundDataDownloadActivity(DateTimeOffset? timestamp = null, DateTimeOffset? startedOn = null, int? percentProgress = null, long? downloadedBytes = null)
        {
            return new ServerEndpointBackgroundDataDownloadActivity(timestamp, startedOn, percentProgress, downloadedBytes, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerEndpointCloudTieringStatus"/>. </summary>
        /// <param name="lastUpdatedOn"> Last updated timestamp. </param>
        /// <param name="health"> Cloud tiering health state. </param>
        /// <param name="healthLastUpdatedOn"> The last updated timestamp of health state. </param>
        /// <param name="lastCloudTieringResult"> Last cloud tiering result (HResult). </param>
        /// <param name="lastSuccessTimestamp"> Last cloud tiering success timestamp. </param>
        /// <param name="spaceSavings"> Information regarding how much local space cloud tiering is saving. </param>
        /// <param name="cachePerformance"> Information regarding how well the local cache on the server is performing. </param>
        /// <param name="filesNotTiering"> Information regarding files that failed to be tiered. </param>
        /// <param name="volumeFreeSpacePolicyStatus"> Status of the volume free space policy. </param>
        /// <param name="datePolicyStatus"> Status of the date policy. </param>
        /// <param name="lowDiskMode"> Information regarding the low disk mode state. </param>
        /// <returns> A new <see cref="Models.ServerEndpointCloudTieringStatus"/> instance for mocking. </returns>
        public static ServerEndpointCloudTieringStatus ServerEndpointCloudTieringStatus(DateTimeOffset? lastUpdatedOn = null, ServerEndpointHealthState? health = null, DateTimeOffset? healthLastUpdatedOn = null, int? lastCloudTieringResult = null, DateTimeOffset? lastSuccessTimestamp = null, CloudTieringSpaceSavings spaceSavings = null, CloudTieringCachePerformance cachePerformance = null, CloudTieringFilesNotTiering filesNotTiering = null, CloudTieringVolumeFreeSpacePolicyStatus volumeFreeSpacePolicyStatus = null, CloudTieringDatePolicyStatus datePolicyStatus = null, CloudTieringLowDiskMode lowDiskMode = null)
        {
            return new ServerEndpointCloudTieringStatus(
                lastUpdatedOn,
                health,
                healthLastUpdatedOn,
                lastCloudTieringResult,
                lastSuccessTimestamp,
                spaceSavings,
                cachePerformance,
                filesNotTiering,
                volumeFreeSpacePolicyStatus,
                datePolicyStatus,
                lowDiskMode,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudTieringSpaceSavings"/>. </summary>
        /// <param name="lastUpdatedOn"> Last updated timestamp. </param>
        /// <param name="volumeSizeInBytes"> Volume size. </param>
        /// <param name="cloudTotalSizeInBytes"> Total size of content in the azure file share. </param>
        /// <param name="cachedSizeInBytes"> Cached content size on the server. </param>
        /// <param name="spaceSavingsPercent"> Percentage of cached size over total size. </param>
        /// <param name="spaceSavingsInBytes"> Count of bytes saved on the server. </param>
        /// <returns> A new <see cref="Models.CloudTieringSpaceSavings"/> instance for mocking. </returns>
        public static CloudTieringSpaceSavings CloudTieringSpaceSavings(DateTimeOffset? lastUpdatedOn = null, long? volumeSizeInBytes = null, long? cloudTotalSizeInBytes = null, long? cachedSizeInBytes = null, int? spaceSavingsPercent = null, long? spaceSavingsInBytes = null)
        {
            return new CloudTieringSpaceSavings(
                lastUpdatedOn,
                volumeSizeInBytes,
                cloudTotalSizeInBytes,
                cachedSizeInBytes,
                spaceSavingsPercent,
                spaceSavingsInBytes,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudTieringCachePerformance"/>. </summary>
        /// <param name="lastUpdatedOn"> Last updated timestamp. </param>
        /// <param name="cacheHitBytes"> Count of bytes that were served from the local server. </param>
        /// <param name="cacheMissBytes"> Count of bytes that were served from the cloud. </param>
        /// <param name="cacheHitBytesPercent"> Percentage of total bytes (hit + miss) that were served from the local server. </param>
        /// <returns> A new <see cref="Models.CloudTieringCachePerformance"/> instance for mocking. </returns>
        public static CloudTieringCachePerformance CloudTieringCachePerformance(DateTimeOffset? lastUpdatedOn = null, long? cacheHitBytes = null, long? cacheMissBytes = null, int? cacheHitBytesPercent = null)
        {
            return new CloudTieringCachePerformance(lastUpdatedOn, cacheHitBytes, cacheMissBytes, cacheHitBytesPercent, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudTieringFilesNotTiering"/>. </summary>
        /// <param name="lastUpdatedOn"> Last updated timestamp. </param>
        /// <param name="totalFileCount"> Last cloud tiering result (HResult). </param>
        /// <param name="errors"> Array of tiering errors. </param>
        /// <returns> A new <see cref="Models.CloudTieringFilesNotTiering"/> instance for mocking. </returns>
        public static CloudTieringFilesNotTiering CloudTieringFilesNotTiering(DateTimeOffset? lastUpdatedOn = null, long? totalFileCount = null, IEnumerable<FilesNotTieringError> errors = null)
        {
            errors ??= new List<FilesNotTieringError>();

            return new CloudTieringFilesNotTiering(lastUpdatedOn, totalFileCount, errors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FilesNotTieringError"/>. </summary>
        /// <param name="errorCode"> Error code (HResult). </param>
        /// <param name="fileCount"> Count of files with this error. </param>
        /// <returns> A new <see cref="Models.FilesNotTieringError"/> instance for mocking. </returns>
        public static FilesNotTieringError FilesNotTieringError(int? errorCode = null, long? fileCount = null)
        {
            return new FilesNotTieringError(errorCode, fileCount, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudTieringVolumeFreeSpacePolicyStatus"/>. </summary>
        /// <param name="lastUpdatedOn"> Last updated timestamp. </param>
        /// <param name="effectiveVolumeFreeSpacePolicy"> In the case where multiple server endpoints are present in a volume, an effective free space policy is applied. </param>
        /// <param name="currentVolumeFreeSpacePercent"> Current volume free space percentage. </param>
        /// <returns> A new <see cref="Models.CloudTieringVolumeFreeSpacePolicyStatus"/> instance for mocking. </returns>
        public static CloudTieringVolumeFreeSpacePolicyStatus CloudTieringVolumeFreeSpacePolicyStatus(DateTimeOffset? lastUpdatedOn = null, int? effectiveVolumeFreeSpacePolicy = null, int? currentVolumeFreeSpacePercent = null)
        {
            return new CloudTieringVolumeFreeSpacePolicyStatus(lastUpdatedOn, effectiveVolumeFreeSpacePolicy, currentVolumeFreeSpacePercent, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudTieringDatePolicyStatus"/>. </summary>
        /// <param name="lastUpdatedOn"> Last updated timestamp. </param>
        /// <param name="tieredFilesMostRecentAccessTimestamp"> Most recent access time of tiered files. </param>
        /// <returns> A new <see cref="Models.CloudTieringDatePolicyStatus"/> instance for mocking. </returns>
        public static CloudTieringDatePolicyStatus CloudTieringDatePolicyStatus(DateTimeOffset? lastUpdatedOn = null, DateTimeOffset? tieredFilesMostRecentAccessTimestamp = null)
        {
            return new CloudTieringDatePolicyStatus(lastUpdatedOn, tieredFilesMostRecentAccessTimestamp, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudTieringLowDiskMode"/>. </summary>
        /// <param name="lastUpdatedOn"> Last updated timestamp. </param>
        /// <param name="state"> Low disk mode state. </param>
        /// <returns> A new <see cref="Models.CloudTieringLowDiskMode"/> instance for mocking. </returns>
        public static CloudTieringLowDiskMode CloudTieringLowDiskMode(DateTimeOffset? lastUpdatedOn = null, CloudTieringLowDiskModeState? state = null)
        {
            return new CloudTieringLowDiskMode(lastUpdatedOn, state, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerEndpointRecallStatus"/>. </summary>
        /// <param name="lastUpdatedOn"> Last updated timestamp. </param>
        /// <param name="totalRecallErrorsCount"> Total count of recall errors. </param>
        /// <param name="recallErrors"> Array of recall errors. </param>
        /// <returns> A new <see cref="Models.ServerEndpointRecallStatus"/> instance for mocking. </returns>
        public static ServerEndpointRecallStatus ServerEndpointRecallStatus(DateTimeOffset? lastUpdatedOn = null, long? totalRecallErrorsCount = null, IEnumerable<ServerEndpointRecallError> recallErrors = null)
        {
            recallErrors ??= new List<ServerEndpointRecallError>();

            return new ServerEndpointRecallStatus(lastUpdatedOn, totalRecallErrorsCount, recallErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerEndpointRecallError"/>. </summary>
        /// <param name="errorCode"> Error code (HResult). </param>
        /// <param name="count"> Count of occurences of the error. </param>
        /// <returns> A new <see cref="Models.ServerEndpointRecallError"/> instance for mocking. </returns>
        public static ServerEndpointRecallError ServerEndpointRecallError(int? errorCode = null, long? count = null)
        {
            return new ServerEndpointRecallError(errorCode, count, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StorageSync.StorageSyncRegisteredServerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="serverCertificate"> Registered Server Certificate. </param>
        /// <param name="agentVersion"> Registered Server Agent Version. </param>
        /// <param name="agentVersionStatus"> Registered Server Agent Version Status. </param>
        /// <param name="agentVersionExpireOn"> Registered Server Agent Version Expiration Date. </param>
        /// <param name="serverOSVersion"> Registered Server OS Version. </param>
        /// <param name="serverManagementErrorCode"> Registered Server Management Error Code. </param>
        /// <param name="lastHeartbeat"> Registered Server last heart beat. </param>
        /// <param name="provisioningState"> Registered Server Provisioning State. </param>
        /// <param name="serverRole"> Registered Server serverRole. </param>
        /// <param name="clusterId"> Registered Server clusterId. </param>
        /// <param name="clusterName"> Registered Server clusterName. </param>
        /// <param name="serverId"> Registered Server serverId. </param>
        /// <param name="storageSyncServiceUid"> Registered Server storageSyncServiceUid. </param>
        /// <param name="lastWorkflowId"> Registered Server lastWorkflowId. </param>
        /// <param name="lastOperationName"> Resource Last Operation Name. </param>
        /// <param name="discoveryEndpointUri"> Resource discoveryEndpointUri. </param>
        /// <param name="resourceLocation"> Resource Location. </param>
        /// <param name="serviceLocation"> Service Location. </param>
        /// <param name="friendlyName"> Friendly Name. </param>
        /// <param name="managementEndpointUri"> Management Endpoint Uri. </param>
        /// <param name="monitoringEndpointUri"> Telemetry Endpoint Uri. </param>
        /// <param name="monitoringConfiguration"> Monitoring Configuration. </param>
        /// <param name="serverName"> Server name. </param>
        /// <returns> A new <see cref="StorageSync.StorageSyncRegisteredServerData"/> instance for mocking. </returns>
        public static StorageSyncRegisteredServerData StorageSyncRegisteredServerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, BinaryData serverCertificate = null, string agentVersion = null, RegisteredServerAgentVersionStatus? agentVersionStatus = null, DateTimeOffset? agentVersionExpireOn = null, string serverOSVersion = null, int? serverManagementErrorCode = null, string lastHeartbeat = null, string provisioningState = null, string serverRole = null, Guid? clusterId = null, string clusterName = null, Guid? serverId = null, Guid? storageSyncServiceUid = null, string lastWorkflowId = null, string lastOperationName = null, Uri discoveryEndpointUri = null, AzureLocation? resourceLocation = null, AzureLocation? serviceLocation = null, string friendlyName = null, Uri managementEndpointUri = null, Uri monitoringEndpointUri = null, string monitoringConfiguration = null, string serverName = null)
        {
            return new StorageSyncRegisteredServerData(
                id,
                name,
                resourceType,
                systemData,
                serverCertificate,
                agentVersion,
                agentVersionStatus,
                agentVersionExpireOn,
                serverOSVersion,
                serverManagementErrorCode,
                lastHeartbeat,
                provisioningState,
                serverRole,
                clusterId,
                clusterName,
                serverId,
                storageSyncServiceUid,
                lastWorkflowId,
                lastOperationName,
                discoveryEndpointUri,
                resourceLocation,
                serviceLocation,
                friendlyName,
                managementEndpointUri,
                monitoringEndpointUri,
                monitoringConfiguration,
                serverName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageSyncRegisteredServerCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="serverCertificate"> Registered Server Certificate. </param>
        /// <param name="agentVersion"> Registered Server Agent Version. </param>
        /// <param name="serverOSVersion"> Registered Server OS Version. </param>
        /// <param name="lastHeartbeat"> Registered Server last heart beat. </param>
        /// <param name="serverRole"> Registered Server serverRole. </param>
        /// <param name="clusterId"> Registered Server clusterId. </param>
        /// <param name="clusterName"> Registered Server clusterName. </param>
        /// <param name="serverId"> Registered Server serverId. </param>
        /// <param name="friendlyName"> Friendly Name. </param>
        /// <returns> A new <see cref="Models.StorageSyncRegisteredServerCreateOrUpdateContent"/> instance for mocking. </returns>
        public static StorageSyncRegisteredServerCreateOrUpdateContent StorageSyncRegisteredServerCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, BinaryData serverCertificate = null, string agentVersion = null, string serverOSVersion = null, string lastHeartbeat = null, string serverRole = null, Guid? clusterId = null, string clusterName = null, Guid? serverId = null, string friendlyName = null)
        {
            return new StorageSyncRegisteredServerCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                serverCertificate,
                agentVersion,
                serverOSVersion,
                lastHeartbeat,
                serverRole,
                clusterId,
                clusterName,
                serverId,
                friendlyName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StorageSync.StorageSyncWorkflowData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="lastStepName"> last step name. </param>
        /// <param name="status"> workflow status. </param>
        /// <param name="operation"> operation direction. </param>
        /// <param name="steps"> workflow steps. </param>
        /// <param name="lastOperationId"> workflow last operation identifier. </param>
        /// <param name="commandName"> workflow command name. </param>
        /// <param name="createdOn"> workflow created timestamp. </param>
        /// <param name="lastStatusUpdatedOn"> workflow last status timestamp. </param>
        /// <returns> A new <see cref="StorageSync.StorageSyncWorkflowData"/> instance for mocking. </returns>
        public static StorageSyncWorkflowData StorageSyncWorkflowData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string lastStepName = null, StorageSyncWorkflowStatus? status = null, StorageSyncOperationDirection? operation = null, string steps = null, Guid? lastOperationId = null, string commandName = null, DateTimeOffset? createdOn = null, DateTimeOffset? lastStatusUpdatedOn = null)
        {
            return new StorageSyncWorkflowData(
                id,
                name,
                resourceType,
                systemData,
                lastStepName,
                status,
                operation,
                steps,
                lastOperationId,
                commandName,
                createdOn,
                lastStatusUpdatedOn,
                serializedAdditionalRawData: null);
        }
    }
}
