// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.StoragePool.Models
{
    internal static partial class StoragePoolSkuRestrictionsTypeExtensions
    {
        public static string ToSerialString(this StoragePoolSkuRestrictionsType value) => value switch
        {
            StoragePoolSkuRestrictionsType.Location => "Location",
            StoragePoolSkuRestrictionsType.Zone => "Zone",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StoragePoolSkuRestrictionsType value.")
        };

        public static StoragePoolSkuRestrictionsType ToStoragePoolSkuRestrictionsType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Location")) return StoragePoolSkuRestrictionsType.Location;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Zone")) return StoragePoolSkuRestrictionsType.Zone;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StoragePoolSkuRestrictionsType value.");
        }
    }
}
