// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.StoragePool.Models
{
    internal static partial class StoragePoolSkuRestrictionsReasonCodeExtensions
    {
        public static string ToSerialString(this StoragePoolSkuRestrictionsReasonCode value) => value switch
        {
            StoragePoolSkuRestrictionsReasonCode.QuotaId => "QuotaId",
            StoragePoolSkuRestrictionsReasonCode.NotAvailableForSubscription => "NotAvailableForSubscription",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StoragePoolSkuRestrictionsReasonCode value.")
        };

        public static StoragePoolSkuRestrictionsReasonCode ToStoragePoolSkuRestrictionsReasonCode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "QuotaId")) return StoragePoolSkuRestrictionsReasonCode.QuotaId;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotAvailableForSubscription")) return StoragePoolSkuRestrictionsReasonCode.NotAvailableForSubscription;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StoragePoolSkuRestrictionsReasonCode value.");
        }
    }
}
