// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StoragePool.Models
{
    /// <summary> Resource SKU Details. </summary>
    public partial class StoragePoolSkuInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StoragePoolSkuInfo"/>. </summary>
        internal StoragePoolSkuInfo()
        {
            Capabilities = new ChangeTrackingList<StoragePoolSkuCapability>();
            Restrictions = new ChangeTrackingList<StoragePoolSkuRestrictions>();
        }

        /// <summary> Initializes a new instance of <see cref="StoragePoolSkuInfo"/>. </summary>
        /// <param name="apiVersion"> StoragePool RP API version. </param>
        /// <param name="resourceType"> StoragePool resource type. </param>
        /// <param name="capabilities"> List of additional capabilities for StoragePool resource. </param>
        /// <param name="locationInfo"> Zones and zone capabilities in those locations where the SKU is available. </param>
        /// <param name="name"> Sku name. </param>
        /// <param name="tier"> Sku tier. </param>
        /// <param name="restrictions"> The restrictions because of which SKU cannot be used. This is empty if there are no restrictions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StoragePoolSkuInfo(string apiVersion, string resourceType, IReadOnlyList<StoragePoolSkuCapability> capabilities, StoragePoolSkuLocationInfo locationInfo, string name, string tier, IReadOnlyList<StoragePoolSkuRestrictions> restrictions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ApiVersion = apiVersion;
            ResourceType = resourceType;
            Capabilities = capabilities;
            LocationInfo = locationInfo;
            Name = name;
            Tier = tier;
            Restrictions = restrictions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> StoragePool RP API version. </summary>
        public string ApiVersion { get; }
        /// <summary> StoragePool resource type. </summary>
        public string ResourceType { get; }
        /// <summary> List of additional capabilities for StoragePool resource. </summary>
        public IReadOnlyList<StoragePoolSkuCapability> Capabilities { get; }
        /// <summary> Zones and zone capabilities in those locations where the SKU is available. </summary>
        public StoragePoolSkuLocationInfo LocationInfo { get; }
        /// <summary> Sku name. </summary>
        public string Name { get; }
        /// <summary> Sku tier. </summary>
        public string Tier { get; }
        /// <summary> The restrictions because of which SKU cannot be used. This is empty if there are no restrictions. </summary>
        public IReadOnlyList<StoragePoolSkuRestrictions> Restrictions { get; }
    }
}
