// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StoragePool.Models
{
    /// <summary> Operational status of the resource. </summary>
    public readonly partial struct StoragePoolOperationalStatus : IEquatable<StoragePoolOperationalStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StoragePoolOperationalStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StoragePoolOperationalStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string UnknownValue = "Unknown";
        private const string HealthyValue = "Healthy";
        private const string UnhealthyValue = "Unhealthy";
        private const string UpdatingValue = "Updating";
        private const string RunningValue = "Running";
        private const string StoppedValue = "Stopped";
        private const string StoppedDeallocatedValue = "Stopped (deallocated)";

        /// <summary> Invalid. </summary>
        public static StoragePoolOperationalStatus Invalid { get; } = new StoragePoolOperationalStatus(InvalidValue);
        /// <summary> Unknown. </summary>
        public static StoragePoolOperationalStatus Unknown { get; } = new StoragePoolOperationalStatus(UnknownValue);
        /// <summary> Healthy. </summary>
        public static StoragePoolOperationalStatus Healthy { get; } = new StoragePoolOperationalStatus(HealthyValue);
        /// <summary> Unhealthy. </summary>
        public static StoragePoolOperationalStatus Unhealthy { get; } = new StoragePoolOperationalStatus(UnhealthyValue);
        /// <summary> Updating. </summary>
        public static StoragePoolOperationalStatus Updating { get; } = new StoragePoolOperationalStatus(UpdatingValue);
        /// <summary> Running. </summary>
        public static StoragePoolOperationalStatus Running { get; } = new StoragePoolOperationalStatus(RunningValue);
        /// <summary> Stopped. </summary>
        public static StoragePoolOperationalStatus Stopped { get; } = new StoragePoolOperationalStatus(StoppedValue);
        /// <summary> Stopped (deallocated). </summary>
        public static StoragePoolOperationalStatus StoppedDeallocated { get; } = new StoragePoolOperationalStatus(StoppedDeallocatedValue);
        /// <summary> Determines if two <see cref="StoragePoolOperationalStatus"/> values are the same. </summary>
        public static bool operator ==(StoragePoolOperationalStatus left, StoragePoolOperationalStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StoragePoolOperationalStatus"/> values are not the same. </summary>
        public static bool operator !=(StoragePoolOperationalStatus left, StoragePoolOperationalStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StoragePoolOperationalStatus"/>. </summary>
        public static implicit operator StoragePoolOperationalStatus(string value) => new StoragePoolOperationalStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StoragePoolOperationalStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StoragePoolOperationalStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
