// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.StoragePool.Models
{
    /// <summary> LUN to expose the Azure Managed Disk. </summary>
    public partial class ManagedDiskIscsiLun
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedDiskIscsiLun"/>. </summary>
        /// <param name="name"> User defined name for iSCSI LUN; example: "lun0". </param>
        /// <param name="managedDiskAzureResourceId"> Azure Resource ID of the Managed Disk. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="managedDiskAzureResourceId"/> is null. </exception>
        public ManagedDiskIscsiLun(string name, ResourceIdentifier managedDiskAzureResourceId)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(managedDiskAzureResourceId, nameof(managedDiskAzureResourceId));

            Name = name;
            ManagedDiskAzureResourceId = managedDiskAzureResourceId;
        }

        /// <summary> Initializes a new instance of <see cref="ManagedDiskIscsiLun"/>. </summary>
        /// <param name="name"> User defined name for iSCSI LUN; example: "lun0". </param>
        /// <param name="managedDiskAzureResourceId"> Azure Resource ID of the Managed Disk. </param>
        /// <param name="lun"> Specifies the Logical Unit Number of the iSCSI LUN. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedDiskIscsiLun(string name, ResourceIdentifier managedDiskAzureResourceId, int? lun, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            ManagedDiskAzureResourceId = managedDiskAzureResourceId;
            Lun = lun;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ManagedDiskIscsiLun"/> for deserialization. </summary>
        internal ManagedDiskIscsiLun()
        {
        }

        /// <summary> User defined name for iSCSI LUN; example: "lun0". </summary>
        public string Name { get; set; }
        /// <summary> Azure Resource ID of the Managed Disk. </summary>
        public ResourceIdentifier ManagedDiskAzureResourceId { get; set; }
        /// <summary> Specifies the Logical Unit Number of the iSCSI LUN. </summary>
        public int? Lun { get; }
    }
}
