// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.StoragePool.Models
{
    /// <summary> Access Control List (ACL) for an iSCSI Target; defines LUN masking policy. </summary>
    public partial class DiskPoolIscsiTargetPortalGroupAcl
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DiskPoolIscsiTargetPortalGroupAcl"/>. </summary>
        /// <param name="initiatorIqn"> iSCSI initiator IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:client". </param>
        /// <param name="mappedLuns"> List of LUN names mapped to the ACL. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="initiatorIqn"/> or <paramref name="mappedLuns"/> is null. </exception>
        public DiskPoolIscsiTargetPortalGroupAcl(string initiatorIqn, IEnumerable<string> mappedLuns)
        {
            Argument.AssertNotNull(initiatorIqn, nameof(initiatorIqn));
            Argument.AssertNotNull(mappedLuns, nameof(mappedLuns));

            InitiatorIqn = initiatorIqn;
            MappedLuns = mappedLuns.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="DiskPoolIscsiTargetPortalGroupAcl"/>. </summary>
        /// <param name="initiatorIqn"> iSCSI initiator IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:client". </param>
        /// <param name="mappedLuns"> List of LUN names mapped to the ACL. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DiskPoolIscsiTargetPortalGroupAcl(string initiatorIqn, IList<string> mappedLuns, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            InitiatorIqn = initiatorIqn;
            MappedLuns = mappedLuns;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DiskPoolIscsiTargetPortalGroupAcl"/> for deserialization. </summary>
        internal DiskPoolIscsiTargetPortalGroupAcl()
        {
        }

        /// <summary> iSCSI initiator IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:client". </summary>
        public string InitiatorIqn { get; set; }
        /// <summary> List of LUN names mapped to the ACL. </summary>
        public IList<string> MappedLuns { get; }
    }
}
